package com.beiming.odr.user.api.dto.requestdto;

import java.io.Serializable;
import java.util.Date;

import com.beiming.framework.page.PageQuery;

import lombok.Data;

/**
 * 菜单参数
 */
@Data
public class MenuInfoReqDTO extends PageQuery implements Serializable {
  /**
   * 菜单id
   */
  private Long id;

  /**
   * 父级菜单 id
   */
  private Long parentId;

  /**
   * 菜单名称
   */
  private String menuName;

  /**
   * 菜单路径
   */
  private String menuUrl;

  /**
   * 菜单类型
   */
  private String menuType;

  /**
   * 菜单是否可用
   */
  private String menuFlag;

  /**
   * 菜单排序
   */
  private Integer menuOrderNo;

  /**
   * 状态 0 正常 1 删除
   */
  private String status;

  /**
   * 备注
   */
  private String remark;

  /**
   * 创建人
   */
  private String createUser;

  /**
   * 创建时间
   */
  private Date createTime;

  /**
   * 修改人
   */
  private String updateUser;

  /**
   * 修改时间
   */
  private Date updateTime;

  /**
   * 版本号
   */
  private Integer version;
  
  /** 关联的下拉列表框的值*/
  private String relationRoleType;

}
