package com.beiming.odr.user.api.dto.requestdto;

import java.io.Serializable;
import java.util.List;
import com.beiming.framework.page.PageQuery;
import lombok.Data;

/**
 * 查询机构dto
 * @author zhiguang
 *
 */
@Data
public class OrganizationListReqDTO extends PageQuery implements Serializable {
  
  /**
   * appName
   */
  private String appName;
  /**
   * 机构类型代码
   */
  private String orgTypeCode;
  
  /**
   * 需排除的机构类型代码集合
   */
  private List<String> excludeOrgTypeCodes;
  
  /**
   * 服务区域代码
   */
  private String serviceAreaCode;
  
  /**
   * 机构名称
   */
  private String orgName;
  
  /**
   * 机构名称（全匹配）
   */
  private String fullOrgName;
  
  /**
   * 调解类型代码
   */
  private String mediateCode;
  
  /**
   * 纠纷类型代码
   */
  private String disputeTypeCode;
  
  /**
   * 需要排除的机构id
   */
  private Long excludeOrgId;
  
  /**
   * 机构id数组
   */
  private List<Long> orgIds;
  
  /**
   * 纠纷发生地等级
   */
  private String disputeAreaLevel;
  
  /**
   * 纠纷发生地代码
   */
  private String disputeAreaCode;
  
  /**
   * 纠纷发生地代码前两位（匹配省市）
   */
  private String disputeAreaCodeTwo;
  
  /**
   * 纠纷发生地代码前四位（匹配区县）
   */
  private String disputeAreaCodeFour;
  
  /**
   * 纠纷发生地代码前六位（匹配街道）
   */
  private String disputeAreaCodeSix;
  
  /**
   * 纠纷发生地代码前九位（匹配社区）
   */
  private String disputeAreaCodeNine;
  
  /**
   * 服务区域代码前两位（匹配省）
   */
  private String serviceAreaCodeTwo;
  
  /**
   * 服务区域代码前四位（匹配市）
   */
  private String serviceAreaCodeFour;
  
  /**
   * 服务区域代码前六位（匹配区）
   */
  private String serviceAreaCodeSix;

  /**
   * 服务区域代码前九位（匹配街道）
   */
  private String serviceAreaCodeNine;
  /**
   * 服务区域代码十二位（匹配社区）
   */
  private String serviceAreaCodeTwelve;

  /**
   * 当前登录用户id
   */
  private String currentUserId;

  /**
   * 备注
   */
  private String remark;
  
  /**
   * 社区地址代码
   */
  private String communityCode;
  /**
   * 街道地址代码
   */
  private String streetCode;
  /**
   * 其他街道代码
   */
  private String otherStreetCode;
  
  /**
   * 其他市代码
   */
  private String otherCityCode;
  
  /**
   * 行政级别等级
   */
  private Integer gradeLevel;

  /**
   * 机构区域代码
   */
  private String orgAreaCode;
  
  /**
   * 诉求机构类型代码
   */
  private List<String> appealOrgTypeCodes;
  
}
