package com.beiming.odr.user.api.dto.requestdto;

import java.io.Serializable;
import java.util.List;
import javax.validation.constraints.NotNull;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 保存领导排班参数
 */
@Data
@ApiModel(value = "保存领导排班参数")
public class SaveLeaderScheduleReqDTO implements Serializable {
  
  /**
   * 批id
   */
  @ApiModelProperty(value = "批id")
  private Long batchId;

  /**
   * 机构id
   */
  @ApiModelProperty(value = "机构id")
  @NotNull(message = "机构id不能为空")
  private Long orgId;

  /**
   * 机构名称
   */
  @ApiModelProperty(value = "机构名称", hidden = true)
  private String orgName;

  /**
   * 机构地址code
   */
  @ApiModelProperty(value = "机构地址code", hidden = true)
  private String orgAreaCode;

  /**
   * 值班日期
   */
  @ApiModelProperty(value = "值班日期")
  private List<String> dutyDates;

  /**
   * 姓名
   */
  @ApiModelProperty(value = "姓名")
  private String userName;

  /**
   * 职务
   */
  @ApiModelProperty(value = "职务")
  private String post;
  @ApiModelProperty(value = "类型(领导和日常)LEAD(\"领导\"), DAY(\"日常\")")
  private String scheduleType;
  @ApiModelProperty(value = "用户id")
  private String userId;
  @ApiModelProperty(value = "类型(日常)RESIDENT(常驻), WHEEL_PARK(轮驻), ACCOMPANY(随驻)")
  private String dayType;

}
