package com.beiming.odr.user.api.dto.requestdto;

import com.beiming.framework.page.PageQuery;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.NotNull;
import java.io.Serializable;


@Data
@NoArgsConstructor
@AllArgsConstructor
@ApiModel(description = "转办机构请求参数")
public class TransferOrgReqDTO extends PageQuery implements Serializable {

  @ApiModelProperty(notes = "查询机构名称", example = "xx机构")
  private String searchOrgName;

  @ApiModelProperty(notes = "当前机构id", example = "2")
  @NotNull(message = "当前机构id不能为空")
  private Long currentOrgId;

  @ApiModelProperty(notes = "机构类型", example = "SETTLED_UNIT")
  private String orgType;
  
}
