package com.beiming.odr.user.api.dto.requestdto;

import java.io.Serializable;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import com.beiming.odr.user.api.common.constants.UserConst;
import com.beiming.odr.user.api.common.enums.PersonTypeEnum;
import lombok.Data;


/**
 * 用户登录，不需要手机号码的登录请求参数
 */
@Data
public class UserLoginAndRegisterReqDTO implements Serializable {

  /** 手机号码 */
  @Pattern(regexp = UserConst.REGEX_MOBILE_EXACT, message = "手机号码格式不对")
  private String mobilePhone;
  
  /** 登录的人员类型 */
  @NotNull(message = "登录的人员类型必填")
  private PersonTypeEnum personType;

  /**
   * 身份证
   */
  private String idCard;

  /**
   * 用户姓名
   */
  private String userName;

  /**
   * 是否实名
   */
  private Boolean isRealName;

  /**
   * 是否实名
   */
  private Boolean isFacialVerify;

  /**
   * 性别
   */
  private String sex;

  /**
   * 地址
   */
  private String address;
}
