package com.beiming.odr.user.api.dto.requestdto;

import java.io.Serializable;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import com.beiming.odr.user.api.common.constants.UserConst;
import com.beiming.odr.user.api.common.enums.PersonTypeEnum;
import com.beiming.odr.user.api.common.enums.UserLoginNotPasswordEnum;
import lombok.Data;


/**
 * 用户登录，不需要手机号码的登录请求参数
 */
@Data
public class UserLoginNotPasswordReqDTO implements Serializable {

  /** 手机号码 */
  @Pattern(regexp = UserConst.REGEX_MOBILE_EXACT, message = "手机号码格式不对")
  private String mobilePhone;
  /**
   * 微信绑定登录的openId
   */
  private String openId;

  /** 非密码登录的登录类型 */
  @NotNull(message = "登录类型必填")
  private UserLoginNotPasswordEnum loginType;

  /** 登录的人员类型 */
  @NotNull(message = "登录的人员类型必填")
  private PersonTypeEnum personType;
  
  /** 微信的登录头像 */
  private String headImgUrl;
}
