package com.beiming.odr.user.api.dto.requestdto.newsinformation;

import java.io.Serializable;
import java.util.Date;
import javax.validation.constraints.NotNull;
import com.beiming.odr.user.api.common.enums.PublishStatusEnums;
import lombok.Data;

/** 修改新闻内容 */
@Data
public class UpdateReqDTO implements Serializable {


  @NotNull(message = "id不能为空")
  private Long id;
  /**
   * 标题
   */
  private String title;

  /**
   * 缩略图
   */
  private String imgUrl;

  /**
   * 作者
   */
  private String author;

  /**
   * 来源渠道
   */
  private String sourceChannel;

  /**
   * 新闻类型代码
   */
  private String newsTypeCode;

  /**
   * 新闻类型名称
   */
  private String newsTypeName;

  /**
   * 内容简介
   */
  private String shortContent;
  /**
   * 内容
   */
  private String content;

  /**
   * 发布时间
   */
  private Date publishDate;

  /**
   * 发布状态(Unpublished 未发布，published 发布，Revoke 撤销)
   */
  private PublishStatusEnums publishStatus;
  
  /** 增殖放流,stock_enhancement*/
  private String remark;

}
