package com.beiming.odr.user.api.dto.responsedto;

import java.io.Serializable;
import java.util.Date;
import com.beiming.odr.user.api.common.enums.ApplicableObjectEnums;
import lombok.NoArgsConstructor;

@NoArgsConstructor
public class CapacityAssessmentResDTO implements Serializable {

  /**
   * 
   */
  private static final long serialVersionUID = 8802014983878848977L;
  /**
   * 唯一索引,自增主键
   */
  private Integer id;

  /**
   * 模板ID,来自CapacityAssessmentTemplateInfo表
   */
  private Integer tempId;

  /**
   * 评估调解员id，评估对象为调解员时必输
   */
  private String userId;

  /**
   * 评估调解员名称，评估对象为调解员时必输
   */
  private String userName;

  /**
   * 机构id/所属机构id
   */
  private String orgId;

  /**
   * 机构名称/所属机构名称
   */
  private String orgName;

  /**
   * 评估对象类型，同模板表中的使用对象，区分机构和调解员
   */
  private ApplicableObjectEnums applicableObject;

  /**
   * 评估周期始：eg：20180101
   */
  private String evaluateCycleStart;

  /**
   * 评估周期尾：eg：20180331
   */
  private String evaluateCycleEnd;

  /**
   * 评估总得分
   */
  private Integer score;

  /**
   * 评估等级，1表示一颗星，以此类推
   */
  private Integer level;

  /**
   * 已受理数
   */
  private Integer acceptedNum;

  /**
   * 受理中数
   */
  private Integer acceptingNum;

  /**
   * 已受理成功数
   */
  private Integer acceptedSuccNum;

  /**
   * 处理率得分
   */
  private Integer completionScore;

  /**
   * 满意度得分
   */
  private Integer satisfactionScore;

  /**
   * 评介数
   */
  private Integer commentNum;

  /**
   * 成功率得分
   */
  private Integer successScore;
  
  /**
   * 地址确认书送达数
   */
  private Integer docAddressNum;

  /**
   * 创建时间
   */
  private Date createTime;

  /**
   * @return the 唯一索引,自增主键
   */
  public Integer getId() {
    return id;
  }

  /**
   * @param 唯一索引,自增主键 the id to set
   */
  public void setId(Integer id) {
    this.id = id;
  }

  /**
   * @return the 模板ID,来自CapacityAssessmentTemplateInfo表
   */
  public Integer getTempId() {
    return tempId;
  }

  /**
   * @param 模板ID,来自CapacityAssessmentTemplateInfo表 the temp_id to set
   */
  public void setTempId(Integer tempId) {
    this.tempId = tempId;
  }

  /**
   * @return the 评估调解员id，评估对象为调解员时必输
   */
  public String getUserId() {
    return userId;
  }

  /**
   * @param 评估调解员id，评估对象为调解员时必输 the user_id to set
   */
  public void setUserId(String userId) {
    this.userId = userId == null ? null : userId.trim();
  }

  /**
   * @return the 评估调解员名称，评估对象为调解员时必输
   */
  public String getUserName() {
    return userName;
  }

  /**
   * @param 评估调解员名称，评估对象为调解员时必输 the user_name to set
   */
  public void setUserName(String userName) {
    this.userName = userName == null ? null : userName.trim();
  }

  /**
   * @return the 机构id/所属机构id
   */
  public String getOrgId() {
    return orgId;
  }

  /**
   * @param 机构id/所属机构id the org_id to set
   */
  public void setOrgId(String orgId) {
    this.orgId = orgId == null ? null : orgId.trim();
  }

  /**
   * @return the 机构名称/所属机构名称
   */
  public String getOrgName() {
    return orgName;
  }

  /**
   * @param 机构名称/所属机构名称 the org_name to set
   */
  public void setOrgName(String orgName) {
    this.orgName = orgName == null ? null : orgName.trim();
  }

  /**
   * @return the 评估对象类型，同模板表中的使用对象，区分机构和调解员
   */
  public ApplicableObjectEnums getApplicableObject() {
    return applicableObject;
  }

  /**
   * @param 评估对象类型，同模板表中的使用对象，区分机构和调解员 the applicable_object to set
   */
  public void setApplicableObject(ApplicableObjectEnums applicableObject) {
    this.applicableObject = applicableObject;
  }

  /**
   * @return the 评估周期始：eg：20180101
   */
  public String getEvaluateCycleStart() {
    return evaluateCycleStart;
  }

  /**
   * @param 评估周期始：eg：20180101 the evaluate_cycle_start to set
   */
  public void setEvaluateCycleStart(String evaluateCycleStart) {
    this.evaluateCycleStart = evaluateCycleStart == null ? null : evaluateCycleStart.trim();
  }

  /**
   * @return the 评估周期尾：eg：20180331
   */
  public String getEvaluateCycleEnd() {
    return evaluateCycleEnd;
  }

  /**
   * @param 评估周期尾：eg：20180331 the evaluate_cycle_end to set
   */
  public void setEvaluateCycleEnd(String evaluateCycleEnd) {
    this.evaluateCycleEnd = evaluateCycleEnd == null ? null : evaluateCycleEnd.trim();
  }

  /**
   * @return the 评估总得分
   */
  public Integer getScore() {
    return score;
  }

  /**
   * @param 评估总得分 the score to set
   */
  public void setScore(Integer score) {
    this.score = score;
  }

  /**
   * @return the 评估等级，1表示一颗星，以此类推
   */
  public Integer getLevel() {
    return level;
  }

  /**
   * @param 评估等级，1表示一颗星，以此类推 the level to set
   */
  public void setLevel(Integer level) {
    this.level = level;
  }

  /**
   * @return the 已受理数
   */
  public Integer getAcceptedNum() {
    return acceptedNum;
  }

  /**
   * @param 已受理数 the accepted_num to set
   */
  public void setAcceptedNum(Integer acceptedNum) {
    this.acceptedNum = acceptedNum;
  }

  /**
   * @return the 受理中数
   */
  public Integer getAcceptingNum() {
    return acceptingNum;
  }

  /**
   * @param 受理中数 the accepting_num to set
   */
  public void setAcceptingNum(Integer acceptingNum) {
    this.acceptingNum = acceptingNum;
  }

  /**
   * @return the 已受理成功数
   */
  public Integer getAcceptedSuccNum() {
    return acceptedSuccNum;
  }

  /**
   * @param 已受理成功数 the accepted_succ_num to set
   */
  public void setAcceptedSuccNum(Integer acceptedSuccNum) {
    this.acceptedSuccNum = acceptedSuccNum;
  }

  /**
   * @return the 处理率得分
   */
  public Integer getCompletionScore() {
    return completionScore;
  }

  /**
   * @param 处理率得分 the completion_score to set
   */
  public void setCompletionScore(Integer completionScore) {
    this.completionScore = completionScore;
  }

  /**
   * @return the 满意度得分
   */
  public Integer getSatisfactionScore() {
    return satisfactionScore;
  }

  /**
   * @param 满意度得分 the satisfaction_score to set
   */
  public void setSatisfactionScore(Integer satisfactionScore) {
    this.satisfactionScore = satisfactionScore;
  }

  /**
   * @return the 评介数
   */
  public Integer getCommentNum() {
    return commentNum;
  }

  /**
   * @param 评介数 the comment_num to set
   */
  public void setCommentNum(Integer commentNum) {
    this.commentNum = commentNum;
  }

  /**
   * @return the 成功率得分
   */
  public Integer getSuccessScore() {
    return successScore;
  }

  /**
   * @param 成功率得分 the success_score to set
   */
  public void setSuccessScore(Integer successScore) {
    this.successScore = successScore;
  }

  /**
   * @return the 创建时间
   */
  public Date getCreateTime() {
    return createTime;
  }

  /**
   * @param 创建时间 the create_time to set
   */
  public void setCreateTime(Date createTime) {
    this.createTime = createTime;
  }

  public Integer getDocAddressNum() {
    return docAddressNum;
  }

  public void setDocAddressNum(Integer docAddressNum) {
    this.docAddressNum = docAddressNum;
  }

}
