package com.beiming.odr.user.api.dto.responsedto;

import java.io.Serializable;
import java.util.Date;
import com.beiming.odr.user.api.common.enums.ApplicableObjectEnums;
import com.beiming.odr.user.api.common.enums.ValuationCycleEnums;
import lombok.NoArgsConstructor;

@NoArgsConstructor
public class CapacityTemplateResDTO implements Serializable {

  /**
   * 
   */
  private static final long serialVersionUID = 510975491327754768L;


  /**
   * 唯一索引,自增主键
   */
  private Integer id;

  /**
   * 模板名称
   */
  private String tempName;

  /**
   * 适用对象
   */
  private ApplicableObjectEnums applicableObject;
  /**
   * 适用对象中文显示
   */
  private String applicableObjectView;

  /**
   * 评估周期
   */
  private ValuationCycleEnums evaluationCycle;
  /**
   * 评估周期中文显示
   */
  private String evaluationCycleView;

  /**
   * 处理率
   */
  private Integer completionPercent;

  /**
   * 满意度
   */
  private Integer satisfactionPercent;

  /**
   * 成功率
   */
  private Integer successPercent;

  /**
   * 1星最低分
   */
  private Integer firstLevelStart;

  /**
   * 1星最高分
   */
  private Integer firstLevelEnd;

  /**
   * 2星最低分
   */
  private Integer secondLevelStart;

  /**
   * 2星最高分
   */
  private Integer secondLevelEnd;

  /**
   * 3星最低分
   */
  private Integer thirdLevelStart;

  /**
   * 3星最高分
   */
  private Integer thirdLevelEnd;

  /**
   * 4星最低分
   */
  private Integer fourthLevelStart;

  /**
   * 4星最高分
   */
  private Integer fourthLevelEnd;

  /**
   * 5星最低分
   */
  private Integer fifthLevelStart;

  /**
   * 5星最高分
   */
  private Integer fifthLevelEnd;


  /**
   * 创建人
   */
  private String createUser;

  /**
   * 创建时间
   */
  private Date createTime;

  /**
   * @return the 唯一索引,自增主键
   */
  public Integer getId() {
    return id;
  }

  /**
   * @param 唯一索引,自增主键 the id to set
   */
  public void setId(Integer id) {
    this.id = id;
  }

  /**
   * @return the 模板名称
   */
  public String getTempName() {
    return tempName;
  }

  /**
   * @param 模板名称 the temp_name to set
   */
  public void setTempName(String tempName) {
    this.tempName = tempName == null ? null : tempName.trim();
  }

  /**
   * @return the 适用对象
   */
  public ApplicableObjectEnums getApplicableObject() {
    return applicableObject;
  }

  /**
   * @param 适用对象 the applicable_object to set
   */
  public void setApplicableObject(ApplicableObjectEnums applicableObject) {
    this.applicableObject = applicableObject;
  }

  /**
   * @return the 评估周期
   */
  public ValuationCycleEnums getEvaluationCycle() {
    return evaluationCycle;
  }

  /**
   * @param 评估周期 the evaluation_cycle to set
   */
  public void setEvaluationCycle(ValuationCycleEnums evaluationCycle) {
    this.evaluationCycle = evaluationCycle;
  }

  /**
   * @return the 处理率
   */
  public Integer getCompletionPercent() {
    return completionPercent;
  }

  /**
   * @param 处理率 the completion_percent to set
   */
  public void setCompletionPercent(Integer completionPercent) {
    this.completionPercent = completionPercent;
  }

  /**
   * @return the 满意度
   */
  public Integer getSatisfactionPercent() {
    return satisfactionPercent;
  }

  /**
   * @param 满意度 the satisfaction_percent to set
   */
  public void setSatisfactionPercent(Integer satisfactionPercent) {
    this.satisfactionPercent = satisfactionPercent;
  }

  /**
   * @return the 成功率
   */
  public Integer getSuccessPercent() {
    return successPercent;
  }

  /**
   * @param 成功率 the success_percent to set
   */
  public void setSuccessPercent(Integer successPercent) {
    this.successPercent = successPercent;
  }

  /**
   * @return the 1星最低分
   */
  public Integer getFirstLevelStart() {
    return firstLevelStart;
  }

  /**
   * @param 1星最低分 the first_level_start to set
   */
  public void setFirstLevelStart(Integer firstLevelStart) {
    this.firstLevelStart = firstLevelStart;
  }

  /**
   * @return the 1星最高分
   */
  public Integer getFirstLevelEnd() {
    return firstLevelEnd;
  }

  /**
   * @param 1星最高分 the first_level_end to set
   */
  public void setFirstLevelEnd(Integer firstLevelEnd) {
    this.firstLevelEnd = firstLevelEnd;
  }

  /**
   * @return the 2星最低分
   */
  public Integer getSecondLevelStart() {
    return secondLevelStart;
  }

  /**
   * @param 2星最低分 the second_level_start to set
   */
  public void setSecondLevelStart(Integer secondLevelStart) {
    this.secondLevelStart = secondLevelStart;
  }

  /**
   * @return the 2星最高分
   */
  public Integer getSecondLevelEnd() {
    return secondLevelEnd;
  }

  /**
   * @param 2星最高分 the second_level_end to set
   */
  public void setSecondLevelEnd(Integer secondLevelEnd) {
    this.secondLevelEnd = secondLevelEnd;
  }

  /**
   * @return the 3星最低分
   */
  public Integer getThirdLevelStart() {
    return thirdLevelStart;
  }

  /**
   * @param 3星最低分 the third_level_start to set
   */
  public void setThirdLevelStart(Integer thirdLevelStart) {
    this.thirdLevelStart = thirdLevelStart;
  }

  /**
   * @return the 3星最高分
   */
  public Integer getThirdLevelEnd() {
    return thirdLevelEnd;
  }

  /**
   * @param 3星最高分 the third_level_end to set
   */
  public void setThirdLevelEnd(Integer thirdLevelEnd) {
    this.thirdLevelEnd = thirdLevelEnd;
  }

  /**
   * @return the 4星最低分
   */
  public Integer getFourthLevelStart() {
    return fourthLevelStart;
  }

  /**
   * @param 4星最低分 the fourth_level_start to set
   */
  public void setFourthLevelStart(Integer fourthLevelStart) {
    this.fourthLevelStart = fourthLevelStart;
  }

  /**
   * @return the 4星最高分
   */
  public Integer getFourthLevelEnd() {
    return fourthLevelEnd;
  }

  /**
   * @param 4星最高分 the fourth_level_end to set
   */
  public void setFourthLevelEnd(Integer fourthLevelEnd) {
    this.fourthLevelEnd = fourthLevelEnd;
  }

  /**
   * @return the 5星最低分
   */
  public Integer getFifthLevelStart() {
    return fifthLevelStart;
  }

  /**
   * @param 5星最低分 the fifth_level_start to set
   */
  public void setFifthLevelStart(Integer fifthLevelStart) {
    this.fifthLevelStart = fifthLevelStart;
  }

  /**
   * @return the 5星最高分
   */
  public Integer getFifthLevelEnd() {
    return fifthLevelEnd;
  }

  /**
   * @param 5星最高分 the fifth_level_end to set
   */
  public void setFifthLevelEnd(Integer fifthLevelEnd) {
    this.fifthLevelEnd = fifthLevelEnd;
  }

  /**
   * @return the 创建人
   */
  public String getCreateUser() {
    return createUser;
  }

  /**
   * @param 创建人 the create_user to set
   */
  public void setCreateUser(String createUser) {
    this.createUser = createUser == null ? null : createUser.trim();
  }

  /**
   * @return the 创建时间
   */
  public Date getCreateTime() {
    return createTime;
  }

  /**
   * @param 创建时间 the create_time to set
   */
  public void setCreateTime(Date createTime) {
    this.createTime = createTime;
  }

  public String getApplicableObjectView() {
    return applicableObject.desc();
  }

  public String getEvaluationCycleView() {
    return evaluationCycle.desc();
  }
}
