package com.beiming.odr.user.api.dto.responsedto;

import java.io.Serializable;
import java.util.List;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

@Data
@ApiModel(value = "领导排班参数")
public class LeaderSchedulePageListResDTO implements Serializable {
  
  @ApiModelProperty(value = "id")
  private Long id;
  /**
   * 批id
   */
  @ApiModelProperty(value = "批id")
  private Long batchId;

  /**
   * 机构id
   */
  @ApiModelProperty(value = "机构id", hidden = true)
  private Long orgId;

  /**
   * 机构名称
   */
  @ApiModelProperty(value = "机构名称", hidden = true)
  private String orgName;

  /**
   * 机构地址code
   */
  @ApiModelProperty(value = "机构地址code", hidden = true)
  private String orgAreaCode;

  /**
   * 值班日期
   */
  @ApiModelProperty(value = "值班日期")
  private List<String> dutyDates;
  
  /**
   * 值班日期
   */
  @ApiModelProperty(value = "值班日期")
  private String dutyDate;

  /**
   * 姓名
   */
  @ApiModelProperty(value = "姓名")
  private String userName;

  /**
   * 职务
   */
  @ApiModelProperty(value = "职务")
  private String post;
  
  /**
   * 是否已过期
   */
  @ApiModelProperty(value = "是否已过期")
  private Boolean overdueFlag;
  
  @ApiModelProperty(value = "类型(领导和日常)")
  private String scheduleType;
  @ApiModelProperty(value = "用户id")
  private String userId;
  @ApiModelProperty(value = "类型(日常)")
  private String dayType;

  
  @ApiModelProperty(value = "常驻")
  private String resident;
  @ApiModelProperty(value = "轮驻")
  private String wheelPark;
  @ApiModelProperty(value = "随驻")
  private String accompany;
}
