package com.beiming.odr.user.api.dto.responsedto;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import com.beiming.odr.user.api.dto.UserInfoDTO;
import com.beiming.odr.user.api.dto.UserMenuInfoDTO;
import com.beiming.odr.user.api.dto.UserRoleInfoDTO;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.util.CollectionUtils;

@Data
@NoArgsConstructor
public class LoginInfoResDTO implements Serializable {
  private static final long serialVersionUID = 1939993907517003148L;

  private UserInfoDTO userInfo;
  private List<UserRoleInfoDTO> userRoles;
  private List<UserMenuInfoDTO> userMenuInfo;
  
  public LoginInfoResDTO(UserInfoDTO userInfo, List<UserRoleInfoDTO> userRoles,
      List<UserMenuInfoDTO> userMenuInfo) {
    if (userInfo != null) {
      this.userInfo = userInfo;
      this.userInfo
          .setIsRealName(userInfo.getIsRealName() == null ? false : userInfo.getIsRealName());
      this.userInfo.setIsFacialVerify(
          userInfo.getIsFacialVerify() == null ? false : userInfo.getIsFacialVerify());
      if (!CollectionUtils.isEmpty(userMenuInfo)) {
        this.userMenuInfo = new ArrayList<>();
        this.userMenuInfo.addAll(userMenuInfo);
      }
      if (!CollectionUtils.isEmpty(userRoles)) {
        this.userRoles = new ArrayList<>();
        this.userRoles.addAll(userRoles);
      }
    }
  }
}
