package com.beiming.odr.user.api.dto.responsedto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;

@Data
@NoArgsConstructor
@ApiModel(description = "转办机构返回参数")
public class TransferOrgResDTO implements Serializable {

  @ApiModelProperty(notes = "机构id", example = "2")
  private Long orgId;

  @ApiModelProperty(notes = "机构名称", example = "宿迁市社会治理服务中心")
  private String orgName;

  @ApiModelProperty(notes = "机构类型", example = "APPEAL_SERVICE_CENTER")
  private String orgType;

  @ApiModelProperty(notes = "机构区域", example = "321300000000")
  private String orgAreaCode;

  @ApiModelProperty(notes = "机构等级", example = "2")
  private Integer orgLevel;
}
