package com.beiming.odr.user.api.dto.responsedto;

import java.io.Serializable;
import java.util.Date;
import lombok.Data;
import lombok.NoArgsConstructor;

@Data
@NoArgsConstructor
public class UserActionLogListResDTO implements Serializable {

  private Long id;

  /**
   * 创建人
   */
  private String createUser;

  /**
   * 创建时间
   */
  private Date createTime;

  /**
   * 操作者id
   */
  private Long userId;

  /**
   * 操作者名称
   */
  private String userName;

  /**
   * 操作者手机号
   */
  private String mobilePhone;

  /**
   * 客户端ip
   */
  private String clientIp;

  /**
   * 服务端ip
   */
  private String serviceIp;

  /**
   * 操作动作code（LOGIN/LOGOUT/APPEAL_ADD/APPEAL_ACCEPT/APPEAL_END/APPEAL_CANCEL）
   */
  private String actionCode;

  /**
   * 操作动作名称
   */
  private String actionName;

  /**
   * 操作内容
   */
  private String actionContent;

  /**
   * 操作结果（SUCCESS/FAIL）
   */
  private String actionResult;

  /**
   * 客户端类型（PC/IOS/ANDROID/WECHAT）
   */
  private String ctype;

}
