package com.beiming.odr.user.api.dto.responsedto;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * 用户统计报表返回参数
 * @author zhiguang
 */
@Data
@NoArgsConstructor
public class UserReportResDTO implements Serializable {
  /**
   * 当前地区名称
   */
  private String areaName;
  
  /**
   * 用户访问总量
   */
  private Integer visitTotalNumber;
  /**
   * 注册总量
   */
  private Integer registerTotalNumber;
  /**
   * 服务人员总量
   */
  private Integer servicePersonTotalNumber;
  /**
   * 服务机构总量
   */
  private Integer organizationTotalNumber;
  
  /**
   * 访问用户量统计
   */
  private List<Map<String, Object>> userVisitStatistics;
  
  /**
   * 注册用户量统计
   */
  private List<Map<String, Object>> userRegisterStatistics;
  
  /**
   * 服务人员统计
   */
  private List<Map<String, Object>> servicePersonStatistics;
  
  /**
   * 区域服务人员统计
   */
  private List<Map<String, Object>> areaServicePersonStatistics;
  
  /**
   * 区域机构统计
   */
  private List<Map<String, Object>> areaOrganizationStatistics;
  
}