/*
 * Decompiled with CFR 0.152.
 */
package com.beiming.odr.user.api.common.utils;

import com.beiming.framework.context.AppNameContextHolder;
import com.beiming.framework.domain.ResultCode;
import com.beiming.framework.enums.AppNameEnums;
import com.beiming.framework.enums.DubboResultCodeEnums;
import com.beiming.framework.util.AssertUtils;
import com.beiming.odr.user.api.common.enums.PasswordFormatTypeEnum;
import com.beiming.odr.user.api.common.utils.Encrypt;
import com.beiming.odr.user.api.common.utils.PassWordUtil;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommonPasswordValidateUtil {
    private static final Logger log = LoggerFactory.getLogger(CommonPasswordValidateUtil.class);

    public static Boolean checkPasswordFlag(String password, String encodePassWord) {
        if (AppNameEnums.YNODR.toString().equalsIgnoreCase(AppNameContextHolder.getAppName())) {
            return Encrypt.matches(password, encodePassWord);
        }
        return PassWordUtil.matches(password, encodePassWord);
    }

    public static String encodePassWord(String passWord) {
        if (AppNameEnums.YNODR.toString().equalsIgnoreCase(AppNameContextHolder.getAppName())) {
            return Encrypt.md5(passWord);
        }
        return PassWordUtil.encodePassWord(passWord);
    }

    public static void checkPasswordFormat(PasswordFormatTypeEnum format, String password, String errorMessage) {
        log.info("\u5bc6\u7801\u683c\u5f0f\u4e3a{}", (Object)format.getName());
        AssertUtils.assertTrue((boolean)StringUtils.isNotBlank((CharSequence)password), (ResultCode)DubboResultCodeEnums.PARAM_ERROR, (String)errorMessage);
        if (AppNameEnums.YNODR.toString().equalsIgnoreCase(AppNameContextHolder.getAppName())) {
            CommonPasswordValidateUtil.checkRegexFormat(password, errorMessage, "^.{6,}$");
        } else if (AppNameEnums.GUIYANGODR.toString().equalsIgnoreCase(AppNameContextHolder.getAppName())) {
            CommonPasswordValidateUtil.checkRegexFormat(password, errorMessage, "^.{8,}$");
        } else if (AppNameEnums.HUAIANODR.toString().equalsIgnoreCase(AppNameContextHolder.getAppName())) {
            CommonPasswordValidateUtil.checkRegexFormat(password, errorMessage, "^[0-9a-zA-Z]{8,16}$");
        } else {
            String reg = "";
            if (PasswordFormatTypeEnum.USER_LOGIN.equals((Object)format)) {
                reg = "^[0-9a-zA-Z]{8,16}$";
            } else {
                log.info("\u91cd\u7f6e\u5bc6\u7801\uff0c\u8bbe\u7f6e\u5bc6\u7801\u683c\u5f0f");
                reg = "^(?!^\\d+$)(?!^[a-zA-Z]+$)(?!^[0-9a-z]+$)(?!^[0-9A-Z]+$)[0-9a-zA-Z]{8,16}$";
            }
            CommonPasswordValidateUtil.checkRegexFormat(password, errorMessage, reg);
        }
    }

    private static void checkRegexFormat(String password, String message, String regex) {
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(password);
        AssertUtils.assertTrue((boolean)matcher.matches(), (ResultCode)DubboResultCodeEnums.PARAM_ERROR, (String)message);
    }

    public static String setDefaultPassword() {
        if (AppNameEnums.YNODR.toString().equalsIgnoreCase(AppNameContextHolder.getAppName())) {
            return "37ad58268d3785e0f661da610c45ef0c";
        }
        return "37ad58268d3785e0f661da610c45ef0c";
    }
}

