package com.beiming.odr.trial.api;

import com.beiming.odr.trial.api.dto.request.AddMatterOfActionPersonDTO;
import com.beiming.odr.trial.api.dto.request.SaveMediationMeetingEventReqDTO;
import com.beiming.odr.trial.api.dto.response.KickUserResponseDTO;
import com.beiming.odr.trial.api.dto.response.KickRoomResponseDTO;

import java.util.ArrayList;
import java.util.List;
import com.beiming.framework.domain.DubboResult;
import com.beiming.odr.trial.api.dto.request.DownTdhCaseInfoRequestDTO;
import com.beiming.odr.trial.api.dto.request.UpdateCaseKtfsRequestDTO;
import com.beiming.odr.trial.api.dto.request.ReloadTdhCaseOrderInfoRequestDTO;
import com.beiming.odr.trial.api.dto.response.CaseInfoResponseDTO;
import com.beiming.odr.trial.api.dto.response.CaseListResDTO;

@SuppressWarnings("rawtypes")
public interface TrialApi {

  DubboResult<CaseInfoResponseDTO> selectCaseInfoByCaseId(String caseId);

  DubboResult<ArrayList<CaseListResDTO>> caseList(List<String> ids);

  /**
   * 更新案件的开庭方式
   * 
   * @param req
   * @return
   */
  DubboResult updateCaseKtfs(UpdateCaseKtfsRequestDTO req);

  /**
   * 下载通达海案件信息接口
   * 
   * @param req
   * @return
   */
  DubboResult excuteDownTdhCaseInfo(DownTdhCaseInfoRequestDTO req);

  /**
   * 更新通达海案件排期信息接口
   * 
   * @param req
   * @return
   */
  DubboResult<Integer> reloadTdhCaseOrderInfo(ReloadTdhCaseOrderInfoRequestDTO req);

  DubboResult<ArrayList<Long>> selectFictitiousJudge(String orgId, String ftbh);

  /**
   * 上传闭庭案件
   * @return
   */
  DubboResult feedbackCase(DownTdhCaseInfoRequestDTO downTdhCaseReqDto);
  
  /**
   * 获取法庭编号字段
   * @param fydm
   * @param andm
   * @param tc
   * @return
   */
  DubboResult<Long> getFtbh(String fydm, String ahdm, String tc);


  DubboResult<String> saveMediationMeetingEvent(SaveMediationMeetingEventReqDTO requestDTO);

  DubboResult<String> getCourtRoomName(String courtRoomCode);

  /**
   * 根据案号查询room信息
   *
   * @return
   */
  DubboResult<ArrayList<KickRoomResponseDTO>> getKickOutRoomByName(String name, Integer pageIndex, Integer pageSize);

  /**
   * 根据roomId获取被踢出的用户id和时间
   *
   * @param realRoomId
   * @return
   */
  DubboResult<ArrayList<KickUserResponseDTO>> getKickOutUserByRoomId(Integer mediationMeetingId,
      String realRoomId);

  /**
   * 插入诉讼事项操作记录
   *
   */
  DubboResult<Boolean> addMatterOfActionPerson(List<AddMatterOfActionPersonDTO> reqDTO);
}
