package com.beiming.odr.trial.api.dto.request;

import java.io.Serializable;
import java.util.Date;
import lombok.Data;

@Data
public class CallbackEventInsertRequestDTO implements Serializable {


  /**
   * 房间id
   */
  private String roomId;

  /**
   * 用户id
   */
  private String userId;

  /**
   * 云资源参数
   */
  private String sdkAppId;

  /**
   * 房间事件组:
   * 1 房间事件组
   * 2 媒体事件组
   */
  private Integer eventGroupId;

  /**
   * 事件类型
   * 101：创建房间
   * 102：解散房间
   * 103：进入房间
   * 104：退出房间
   * 105：切换角色
   * 201：开始推送视频数据
   * 202：停止推送视频数据
   * 203：开始推送音频数据
   * 204：停止推送音频数据
   * 205：开始推送辅路数据
   * 206：停止推送辅路数据
   */
  private Integer eventType;

  /**
   * 事件发生时间
   */
  private Date eventTime;


  /**
   * 终端类型
   * 1：Windows 端
   * 2：Android 端
   * 3：iOS 端
   * 4：Linux 端
   * 100：其他
   */
  private Integer terminalType;


  /**
   * 具体原因
   * 进房：
   * 1：正常进房
   * 2：切换网络
   * 3：超时重试
   * 4：跨房连麦进房
   * 退房：
   * 1：正常退房
   * 2：超时离开
   * 3：房间用户被移出
   * 4：取消连麦退房
   * 5：强杀
   */
  private Integer reason;

  /**
   * 用户类型
   * 1：webrtc
   * 2：小程序
   * 3：Native SDK
   */
  private Integer userType;
}
