package com.beiming.odr.trial.api.dto.response;

import java.io.Serializable;
import java.util.Date;
import lombok.Data;

@Data
public class JoinRoomOverTimeResponseDTO implements Serializable {

  private Integer id;

  /**
   * 房间id
   */
  private String roomId;

  /**
   * 用户id
   */
  private String userId;

  /**
   * 云资源参数
   */
  private String sdkAppId;

  /**
   * 房间事件组:
   * 1 房间事件组
   * 2 媒体事件组
   */
  private Integer eventGroupId;

  /**
   * 事件类型
   * 101：创建房间
   * 102：解散房间
   * 103：进入房间
   * 104：退出房间
   * 105：切换角色
   * 201：开始推送视频数据
   * 202：停止推送视频数据
   * 203：开始推送音频数据
   * 204：停止推送音频数据
   * 205：开始推送辅路数据
   * 206：停止推送辅路数据
   */
  private Integer eventType;

  /**
   * 事件发生时间
   */
  private Date eventStartTime;

  /**
   * 事件回调时间
   */
  private Date eventEndTime;
}
