/* 
 * 新环境中,先执行文件 ReportTables.table.sql 中的语句
 * */
			ALTER TABLE mediator_statistic_daily_temp
	ADD COLUMN `medi_timely_response`  int  DEFAULT 0 COMMENT '调解员及时响应数' AFTER `data_type`;
			ALTER TABLE mediator_statistic_daily_temp
	ADD COLUMN `medi_out_timely_response`  int  DEFAULT 0 COMMENT '调解员超期响应数' AFTER `data_type`;
			ALTER TABLE mediator_statistic_daily_temp
	ADD COLUMN `medi_timely_response_per`  int  DEFAULT 0 COMMENT '调解员及时响应率' AFTER `data_type`;
			ALTER TABLE mediator_statistic_daily_temp  
	ADD COLUMN `medi_out_timely_not_response`  int  DEFAULT 0 COMMENT '调解员超期未响应' AFTER `data_type`;
	
				ALTER TABLE org_mediation_statistic_daily
	ADD COLUMN `medi_timely_response`  int  DEFAULT 0 COMMENT '调解员及时响应数' AFTER `data_type`;
			ALTER TABLE org_mediation_statistic_daily
	ADD COLUMN `medi_out_timely_response`  int  DEFAULT 0 COMMENT '调解员超期响应数' AFTER `data_type`;
			ALTER TABLE org_mediation_statistic_daily
	ADD COLUMN `medi_timely_response_per`  int  DEFAULT 0 COMMENT '调解员及时响应率' AFTER `data_type`;
			ALTER TABLE org_mediation_statistic_daily  
	ADD COLUMN `medi_out_timely_not_response`  int  DEFAULT 0 COMMENT '调解员超期未响应' AFTER `data_type`;
				ALTER TABLE org_mediation_statistic_daily  
	ADD COLUMN `medi_not_timely_response`  int  DEFAULT 0 COMMENT '调解员未及时响应数' AFTER `data_type`;
/* 表一 */
CREATE TABLE `medi_case_response_detail_temp` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `subject_id` bigint(20) DEFAULT NULL COMMENT '案件ID',
  `biz_time` timestamp  NULL DEFAULT NULL  COMMENT '响应时间-统计日期',
  `assigned_time` timestamp     COMMENT '分配给调解员的时间',  
  `is_timely_resp` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否及时响应,0不及时,1及时',  
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  PRIMARY KEY (`id`),
  KEY `idx_subject_id` (`subject_id`) USING BTREE
  
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COMMENT='调解员已响应案件详情表';

/* 表二 */
CREATE TABLE `medi_case_response_count_detail_temp` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `area_code` varchar(20) DEFAULT NULL COMMENT '所在区域代码',
  `org_code` varchar(20) DEFAULT NULL COMMENT '机构名称',
  `user_id` varchar(20) DEFAULT NULL COMMENT '用户ID,调解员ID',
  `is_timely_resp` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否及时响应,0不及时,1及时',  
  `case_count` int(10) DEFAULT '0' COMMENT '案件数',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  PRIMARY KEY (`id`)
  
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COMMENT='调解员已响应案件数量详情表';


CREATE TABLE `medi_case_un_response_detail_temp` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `subject_id` bigint(20) DEFAULT NULL COMMENT '案件ID',
  `biz_time` timestamp   NULL DEFAULT NULL  COMMENT '统计日期',
  `assigned_time` timestamp   NULL DEFAULT NULL  COMMENT '分配给调解员的时间',  
  `is_time_out` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否超期,0未超期,1超期',  
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  PRIMARY KEY (`id`),
  KEY `idx_subject_id` (`subject_id`) USING BTREE
  
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COMMENT='调解员未响应案件详情表';

CREATE TABLE `medi_out_time_un_response_case_count_detail_temp` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `area_code` varchar(20) DEFAULT NULL COMMENT '所在区域代码',
  `org_code` varchar(20) DEFAULT NULL COMMENT '机构名称',
  `user_id` varchar(20) DEFAULT NULL COMMENT '用户ID,调解员ID',
  `is_time_out` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否超期,0未超期,1超期',  
  `case_count` int(10) DEFAULT '0' COMMENT '案件数',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  PRIMARY KEY (`id`)
  
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COMMENT='调解员超期未响应案件数量详情表';


/* 机构相关表结构 */
		ALTER TABLE  org_statistic_daily_temp
	ADD COLUMN `org_timely_response`  int  DEFAULT 0 COMMENT '机构及时响应数' AFTER `data_type`;
			ALTER TABLE org_statistic_daily_temp
	ADD COLUMN `org_not_timely_response`  int  DEFAULT 0 COMMENT '机构未及时响应数(包含未响应和响应)' AFTER `org_timely_response`;
			ALTER TABLE org_statistic_daily_temp
	ADD COLUMN `org_out_timely_not_response`  int  DEFAULT 0 COMMENT '机构超期未响应数' AFTER `org_not_timely_response`;
			ALTER TABLE org_statistic_daily_temp
	ADD COLUMN `org_out_timely_response`  int  DEFAULT 0 COMMENT '机构超期响应数' AFTER `org_out_timely_not_response`;
			ALTER TABLE org_statistic_daily_temp
	ADD COLUMN `org_timely_response_per`  int  DEFAULT 0 COMMENT '机构及时响应率' AFTER `org_out_timely_response`;
ALTER TABLE org_statistic_daily_temp
	ADD COLUMN `org_case_transfer_out`  int  DEFAULT 0 COMMENT '机构案件转出量' AFTER `org_timely_response_per`;
ALTER TABLE org_statistic_daily_temp
	ADD COLUMN `org_case_transfer_in`  int  DEFAULT 0 COMMENT '机构案件转入量' AFTER `org_timely_response_per`;
	
	
ALTER TABLE  org_mediation_statistic_daily
	ADD COLUMN `org_timely_response`  int  DEFAULT 0 COMMENT '机构及时响应数' AFTER `data_type`;
ALTER TABLE org_mediation_statistic_daily
	ADD COLUMN `org_not_timely_response`  int  DEFAULT 0 COMMENT '机构未及时响应数(包含未响应和响应)' AFTER `org_timely_response`;
ALTER TABLE org_mediation_statistic_daily
	ADD COLUMN `org_out_timely_not_response`  int  DEFAULT 0 COMMENT '机构超期未响应数' AFTER `org_not_timely_response`;
ALTER TABLE org_mediation_statistic_daily
	ADD COLUMN `org_out_timely_response`  int  DEFAULT 0 COMMENT '机构超期响应数(每天增量)' AFTER `org_out_timely_not_response`;
ALTER TABLE org_mediation_statistic_daily
	ADD COLUMN `org_timely_response_per`  int  DEFAULT 0 COMMENT '机构及时响应率' AFTER `org_out_timely_response`;
ALTER TABLE org_mediation_statistic_daily
	ADD COLUMN `org_case_transfer_out`  int  DEFAULT 0 COMMENT '机构案件转出量' AFTER `org_timely_response_per`;
ALTER TABLE org_mediation_statistic_daily
	ADD COLUMN `org_case_transfer_in`  int  DEFAULT 0 COMMENT '机构案件转入量' AFTER `org_timely_response_per`;

   CREATE TABLE `org_case_apply_or_transfer_time_temp` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `subject_id` bigint(20) DEFAULT NULL COMMENT '案件ID',
  `biz_time` timestamp   NULL DEFAULT NULL  COMMENT '统计日期',
  `apply_time` timestamp   NULL DEFAULT NULL   COMMENT '用户申请时间或者机构转移案件时间', 
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  PRIMARY KEY (`id`),
  KEY `idx_subject_id` (`subject_id`) USING BTREE
  
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COMMENT='机构案件申请或转移最新时间临时表';

   CREATE TABLE `org_case_resp_time_temp` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `subject_id` bigint(20) DEFAULT NULL COMMENT '案件ID',
  `biz_time` timestamp   NULL DEFAULT NULL  COMMENT '统计日期',
  `resp_time` timestamp    NULL DEFAULT NULL  COMMENT '机构响应案件时间', 
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  PRIMARY KEY (`id`),
  KEY `idx_subject_id` (`subject_id`) USING BTREE
  
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COMMENT='机构响应案件时间临时表';

   CREATE TABLE `org_case_resp_detail_temp` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `subject_id` bigint(20) DEFAULT NULL COMMENT '案件ID',
  `biz_time` timestamp   NULL DEFAULT NULL COMMENT '统计日期',
  `org_id` varchar(20) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '机构代码',
  `apply_time` timestamp    NULL DEFAULT NULL COMMENT '用户申请时间或者机构转移案件时间', 
  `resp_time` timestamp    NULL DEFAULT NULL COMMENT '机构响应案件时间', 
  `case_type` int(10) DEFAULT '0' COMMENT '0 未响应, 1, 已经响应',
  `is_time_out` int(10) DEFAULT '0' COMMENT '0 未超期, 1, 超期',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  PRIMARY KEY (`id`),
  KEY `idx_subject_id` (`subject_id`) USING BTREE
  
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COMMENT='机构案件响应详情临时表';

CREATE TABLE `area_medi_count_info_temp` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '自增id',
  `biz_date` timestamp NULL DEFAULT NULL COMMENT '统计日期',
  `area_code` varchar(20) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '区域代码',
  `area_name` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '区域名称',
  `parent_area_code` varchar(20) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '上级区域代码',
  `medi_count` int(10) DEFAULT '0' COMMENT '调解员数',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='调解员数区域分布临时表';


ALTER TABLE area_case_info_total
	ADD COLUMN `case_apply_count`  int  DEFAULT 0 COMMENT '收案数' AFTER `parent_area_code`;
ALTER TABLE area_case_info_total
	ADD COLUMN `mediator_count`  int  DEFAULT 0 COMMENT '调解员数' AFTER `case_not_end_count`;
ALTER TABLE area_case_info_total
	ADD COLUMN `org_count`  int  DEFAULT 0 COMMENT '机构数' AFTER `case_not_end_count`;
	
ALTER TABLE area_case_info_total
	ADD COLUMN `medi_timely_resp_rate`  varchar(20)  DEFAULT 0 COMMENT '调解员及时响应率' AFTER `case_not_end_count`;	
ALTER TABLE area_case_info_total
	ADD COLUMN `medi_out_timely_not_response` int(11) DEFAULT '0' COMMENT '调解员超期未响应(累计)' AFTER `case_not_end_count`;
ALTER TABLE area_case_info_total
	ADD COLUMN `medi_out_timely_resp`  int  DEFAULT 0 COMMENT '调解员超时响应数' AFTER `case_not_end_count`;	
ALTER TABLE area_case_info_total
	ADD COLUMN `medi_timely_resp`  int  DEFAULT 0 COMMENT '调解员及时响应数' AFTER `case_not_end_count`;
	
ALTER TABLE area_case_info_total
	ADD COLUMN `org_timely_resp_rate`  varchar(20)  DEFAULT 0 COMMENT '机构及时响应率' AFTER `case_not_end_count`;	
ALTER TABLE area_case_info_total
	ADD COLUMN `org_out_timely_resp`  int  DEFAULT 0 COMMENT '机构超时响应数' AFTER `case_not_end_count`;
ALTER TABLE area_case_info_total
	ADD COLUMN `org_timely_resp`  int  DEFAULT 0 COMMENT '机构及时响应数' AFTER `case_not_end_count`;
ALTER TABLE area_case_info_total
	ADD COLUMN `org_out_timely_not_response` int(11) DEFAULT '0' COMMENT '机构超期未响应数(累计)'AFTER `case_not_end_count`;

CREATE TABLE `mediation_sex_and_age_statistics` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '自增id',
  `biz_date` timestamp NULL DEFAULT NULL COMMENT '统计日期',
  `area_code` varchar(20) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '所在区域代码',
  `parent_area_code` varchar(20) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '上级区域代码',
  `male` int(11) DEFAULT '0' COMMENT '男调解员',
  `female` int(11) DEFAULT '0' COMMENT '女调解员',
  `unknown_sex` int(11) DEFAULT '0' COMMENT '性别未知调解员',
  `less_twenty` int(11) DEFAULT '0' COMMENT '小于等于20岁的调解员',
  `less_forty` int(11) DEFAULT '0' COMMENT '21-40岁的调解员',
  `less_sixty` int(11) DEFAULT '0' COMMENT '41-60岁的调解员',
  `more_sixty` int(11) DEFAULT '0' COMMENT '60岁以上的调解员',
  `status` varchar(2) CHARACTER SET utf32 COLLATE utf32_general_ci DEFAULT '0' COMMENT '状态 0 正常 1 删除',
  `remark` varchar(1024) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '备注',
  `create_user` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '创建人',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_user` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '修改人',
  `update_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  `version` int(11) DEFAULT '0' COMMENT '版本号',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=556 DEFAULT CHARSET=utf8 COMMENT='调解员年龄性别统计表';

CREATE TABLE `areas_full_tenant` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '自增id',
  `code` varchar(16) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '地区代码',
  `name` varchar(500) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '地区名称',
  `full_name` varchar(1024) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '加上父级的名称和自己的名称',
  `level` int(1) DEFAULT NULL COMMENT '等级',
  `parent_code` varchar(20) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '父级地区代码',
  `province_code` varchar(16) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '省',
  `province_name` varchar(500) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '省名称',
  `city_code` varchar(16) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '市代码',
  `city_name` varchar(500) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '市名称',
  `area_code` varchar(16) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '区代码',
  `area_name` varchar(500) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '区名称',
  `street_code` varchar(16) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '街道代码',
  `street_name` varchar(500) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '街道名称',
  `community_code` varchar(16) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '社区代码',
  `community_name` varchar(500) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '社区名称',
  `status` varchar(2) CHARACTER SET utf32 COLLATE utf32_general_ci DEFAULT '0' COMMENT '状态 0 正常 1 删除',
  `remark` varchar(1024) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '备注',
  `create_user` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '创建人',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_user` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '修改人',
  `update_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  `version` int(11) DEFAULT '0' COMMENT '版本号',
  PRIMARY KEY (`id`),
  UNIQUE KEY `unique_index_areas_code` (`code`) USING BTREE,
  KEY `index_parent_code` (`parent_code`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=256 DEFAULT CHARSET=utf8 COMMENT='租户完整区域表';

drop TABLE areas_case_transfer_out_temp;
CREATE TABLE `areas_case_transfer_out_temp` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '自增',
  `province_code` varchar(16) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '省',
  `province_name` varchar(500) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '省名称',
  `city_code` varchar(16) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '市代码',
  `city_name` varchar(500) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '市名称',
  `area_code` varchar(16) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '区代码',
  `area_name` varchar(500) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '区名称',
  `street_code` varchar(16) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '街道代码',
  `street_name` varchar(500) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '街道名称',
  `community_code` varchar(16) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '社区代码',
  `community_name` varchar(500) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '社区名称',
  `mediate_code` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '调解类型代码',
  `mediate_name` varchar(256) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '调解类型名称',
  `department_code` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '部门代码',
  `department_name` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '部门名称',
  `dispute_type_code` varchar(256) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '纠纷类型字典表code',
  `dispute_type` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '纠纷类型',
  `root_type` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '一级来源',
  `second_level` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '二级来源',
  `is_transfer_in` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否转入,是的时候law_progress_id为转移表ID',
  `law_progress_id` bigint(20) DEFAULT NULL COMMENT '进度表ID/转移表ID',
  `law_case_id` bigint(20) DEFAULT NULL COMMENT '案件表ID',
  `org_id` bigint(20) DEFAULT NULL COMMENT '机构id',
  `creator_id` bigint(20) DEFAULT NULL COMMENT '案件录入人id',
  `creator_type` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '案件录入人的身份',
  `to_org_id` bigint(20) DEFAULT NULL COMMENT '机构id',
  `to_province_code` varchar(16) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '省',
  `to_city_code` varchar(16) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '市代码',
  `to_area_code` varchar(16) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '区代码',
  `to_street_code` varchar(16) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '街道代码',
  `to_community_code` varchar(16) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '社区代码',
  `city_count` int(10) DEFAULT '0' COMMENT '市转出数',
  `area_count` int(10) DEFAULT '0' COMMENT '区转出数',
  `street_count` int(10) DEFAULT '0' COMMENT '街道转出数',
  `community_count` int(10) DEFAULT '0' COMMENT '社区转出数',
  `create_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=244 DEFAULT CHARSET=utf8 COMMENT='区域案件转出数细分统计临时表';


drop TABLE area_case_info_total_temp;
CREATE TABLE `area_case_info_total_temp` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '自增id',
  `biz_date` timestamp NULL DEFAULT NULL COMMENT '统计日期',
  `area_code` varchar(20) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '区域代码',
  `area_name` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '区域名称',
  `parent_area_code` varchar(20) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '上级区域代码',
  `case_apply_count` int(10) DEFAULT '0' COMMENT '收案数',
  `case_accept_count` int(10) DEFAULT '0' COMMENT '已受理数',
  `case_handle_count` int(10) DEFAULT '0' COMMENT '已处理数',
  `case_refuse_count` int(10) DEFAULT '0' COMMENT '不受理',
  `overdue_unresponse_count` int(10) DEFAULT '0' COMMENT '超期未响应',
  `one_star` int(10) DEFAULT '0' COMMENT '1星数',
  `tow_star` int(10) DEFAULT '0' COMMENT '2星数',
  `three_star` int(10) DEFAULT '0' COMMENT '3星数',
  `four_star` int(10) DEFAULT '0' COMMENT '4星数',
  `five_star` int(10) DEFAULT '0' COMMENT '5星数',
  `case_fail_count` int(10) DEFAULT '0' COMMENT '调解失败数',
  `case_end_count` int(10) DEFAULT '0' COMMENT '结案数',
  `case_not_end_count` int(10) DEFAULT '0' COMMENT '未结案数',
  `org_out_timely_not_response` int(11) DEFAULT '0' COMMENT '机构超期未响应数(累计)',
  `medi_out_timely_not_response` int(11) DEFAULT '0' COMMENT '调解员超期未响应(累计)',
  `medi_timely_resp_rate` varchar(20) DEFAULT '0' COMMENT '调解员及时响应率',
  `org_timely_resp_rate` varchar(20) DEFAULT '0' COMMENT '机构及时响应率',
  `medi_out_timely_resp` int(11) DEFAULT '0' COMMENT '调解员超时响应数',
  `medi_timely_resp` int(11) DEFAULT '0' COMMENT '调解员及时响应数',
  `org_out_timely_resp` int(11) DEFAULT '0' COMMENT '机构超时响应数',
  `org_timely_resp` int(11) DEFAULT '0' COMMENT '机构及时响应数',
  `org_count` int(11) DEFAULT '0' COMMENT '机构数',
  `mediator_count` int(11) DEFAULT '0' COMMENT '调解员数',
  `status` varchar(2) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT '0' COMMENT '状态 0 正常 1 删除',
  `remark` varchar(1024) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '备注',
  `create_user` varchar(36) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '创建人',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_user` varchar(36) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '修改人',
  `update_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  `version` int(11) DEFAULT '0' COMMENT '版本号',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COMMENT='资源报表总览临时表';
