drop TABLE areas_case_apply_temp;
CREATE TABLE `areas_case_apply_temp` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '自增',
  `province_code` varchar(16) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '省',
  `province_name` varchar(500) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '省名称',
  `city_code` varchar(16) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '市代码',
  `city_name` varchar(500) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '市名称',
  `area_code` varchar(16) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '区代码',
  `area_name` varchar(500) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '区名称',
  `street_code` varchar(16) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '街道代码',
  `street_name` varchar(500) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '街道名称',
  `community_code` varchar(16) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '社区代码',
  `community_name` varchar(500) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '社区名称',
  `mediate_code` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '调解类型代码',
  `mediate_name` varchar(256) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '调解类型名称',
  `department_code` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '部门代码',
  `department_name` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '部门名称',
  `dispute_type_code` varchar(256) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '纠纷类型字典表code',
  `dispute_type` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '纠纷类型',
  `root_type` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '一级来源',
  `second_level` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '二级来源',
  `is_transfer_in` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否转入,是的时候law_progress_id为转移表ID',
  `law_progress_id` bigint(20) DEFAULT NULL COMMENT '进度表ID/转移表ID',
  `law_case_id` bigint(20) DEFAULT NULL COMMENT '案件表ID',
  `org_id` bigint(20) DEFAULT NULL COMMENT '机构id',
  `creator_id` bigint(20) DEFAULT NULL COMMENT '案件录入人id',
  `creator_type` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '案件录入人的身份',
  `create_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB   DEFAULT CHARSET=utf8 COMMENT='区域收案数细分统计临时表';


drop TABLE areas_case_transfer_temp;
CREATE TABLE `areas_case_transfer_temp` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '自增',
  `province_code` varchar(16) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '省',
  `province_name` varchar(500) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '省名称',
  `city_code` varchar(16) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '市代码',
  `city_name` varchar(500) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '市名称',
  `area_code` varchar(16) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '区代码',
  `area_name` varchar(500) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '区名称',
  `street_code` varchar(16) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '街道代码',
  `street_name` varchar(500) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '街道名称',
  `community_code` varchar(16) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '社区代码',
  `community_name` varchar(500) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '社区名称',
  `mediate_code` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '调解类型代码',
  `mediate_name` varchar(256) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '调解类型名称',
  `department_code` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '部门代码',
  `department_name` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '部门名称',
  `dispute_type_code` varchar(256) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '纠纷类型字典表code',
  `dispute_type` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '纠纷类型',
  `root_type` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '一级来源',
  `second_level` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '二级来源',
  `is_transfer_in` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否转入,是的时候law_progress_id为转移表ID',
  `law_progress_id` bigint(20) DEFAULT NULL COMMENT '进度表ID/转移表ID',
  `law_case_id` bigint(20) DEFAULT NULL COMMENT '案件表ID',
  `org_id` bigint(20) DEFAULT NULL COMMENT '机构id',
  `creator_id` bigint(20) DEFAULT NULL COMMENT '案件录入人id',
  `creator_type` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '案件录入人的身份',
  `from_org_id` bigint(20) DEFAULT NULL COMMENT '机构id',
  `from_province_code` varchar(16) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '省',
  `from_city_code` varchar(16) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '市代码',
  `from_area_code` varchar(16) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '区代码',
  `from_street_code` varchar(16) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '街道代码',
  `from_community_code` varchar(16) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '社区代码',
  `city_count` int(10) DEFAULT '0' COMMENT '市转入数',
  `area_count` int(10) DEFAULT '0' COMMENT '区转入数',
  `street_count` int(10) DEFAULT '0' COMMENT '街道转入数',
  `community_count` int(10) DEFAULT '0' COMMENT '社区转入数',
  `create_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB   DEFAULT CHARSET=utf8 COMMENT='区域案件转移数细分统计临时表';

drop TABLE areas_case_apply_detail_temp;
CREATE TABLE `areas_case_apply_detail_temp` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '自增',
  `biz_date` timestamp NULL DEFAULT NULL COMMENT '统计日期',
  `province_code` varchar(16) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '省',
  `province_name` varchar(500) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '省名称',
  `city_code` varchar(16) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '市代码',
  `city_name` varchar(500) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '市名称',
  `area_code` varchar(16) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '区代码',
  `area_name` varchar(500) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '区名称',
  `street_code` varchar(16) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '街道代码',
  `street_name` varchar(500) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '街道名称',
  `community_code` varchar(16) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '社区代码',
  `community_name` varchar(500) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '社区名称',
  `mediate_code` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '调解类型代码',
  `mediate_name` varchar(256) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '调解类型名称',
  `department_code` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '部门代码',
  `department_name` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '部门名称',
  `dispute_type_code` varchar(256) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '纠纷类型字典表code',
  `dispute_type` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '纠纷类型',
  `root_type` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '一级来源',
  `second_level` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '二级来源',
  `org_id` bigint(20) DEFAULT NULL COMMENT '机构id',
  `apply_count` int(10) DEFAULT '0' COMMENT '收案数',
  `city_count_out` int(10) DEFAULT '0' COMMENT '城市转出数',
  `area_count_out` int(10) DEFAULT '0' COMMENT '区域转出数',
  `street_count_out` int(10) DEFAULT '0' COMMENT '街道转出数',
  `community_count_out` int(10) DEFAULT '0' COMMENT '社区转出数',
  `city_count_in` int(10) DEFAULT '0' COMMENT '城市转入数',
  `area_count_in` int(10) DEFAULT '0' COMMENT '区域转入数',
  `street_count_in` int(10) DEFAULT '0' COMMENT '街道转入数',
  `community_count_in` int(10) DEFAULT '0' COMMENT '社区转入数',
  `status` varchar(2) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT '0' COMMENT '状态 0 正常 1 删除',
  `remark` varchar(1024) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '备注',
  `create_user` varchar(36) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '创建人',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_user` varchar(36) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '修改人',
  `update_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  `version` int(11) DEFAULT '0' COMMENT '版本号',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=575 DEFAULT CHARSET=utf8 COMMENT='区域案件收案数细分统计表';

CREATE TABLE `areas_case_apply_detail` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '自增',
  `biz_date` timestamp NULL DEFAULT NULL COMMENT '统计日期',
  `province_code` varchar(16) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '省',
  `province_name` varchar(500) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '省名称',
  `city_code` varchar(16) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '市代码',
  `city_name` varchar(500) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '市名称',
  `area_code` varchar(16) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '区代码',
  `area_name` varchar(500) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '区名称',
  `street_code` varchar(16) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '街道代码',
  `street_name` varchar(500) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '街道名称',
  `community_code` varchar(16) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '社区代码',
  `community_name` varchar(500) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '社区名称',
  `mediate_code` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '调解类型代码',
  `mediate_name` varchar(256) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '调解类型名称',
  `department_code` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '部门代码',
  `department_name` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '部门名称',
  `dispute_type_code` varchar(256) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '纠纷类型字典表code',
  `dispute_type` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '纠纷类型',
  `root_type` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '一级来源',
  `second_level` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '二级来源',
  `org_id` bigint(20) DEFAULT NULL COMMENT '机构id',
  `apply_count` int(10) DEFAULT '0' COMMENT '收案数',
  `city_count_out` int(10) DEFAULT '0' COMMENT '城市转出数',
  `area_count_out` int(10) DEFAULT '0' COMMENT '区域转出数',
  `street_count_out` int(10) DEFAULT '0' COMMENT '街道转出数',
  `community_count_out` int(10) DEFAULT '0' COMMENT '社区转出数',
  `city_count_in` int(10) DEFAULT '0' COMMENT '城市转入数',
  `area_count_in` int(10) DEFAULT '0' COMMENT '区域转入数',
  `street_count_in` int(10) DEFAULT '0' COMMENT '街道转入数',
  `community_count_in` int(10) DEFAULT '0' COMMENT '社区转入数',
  `status` varchar(2) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT '0' COMMENT '状态 0 正常 1 删除',
  `remark` varchar(1024) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '备注',
  `create_user` varchar(36) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '创建人',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_user` varchar(36) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '修改人',
  `update_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  `version` int(11) DEFAULT '0' COMMENT '版本号',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='区域案件收案数细分统计表';