	/* 资源报表统计相关的临时表建表语句
	 * 只需在 sjsodr-write-datareport 库中执行
	 *  */
CREATE TABLE `area_case_info_total` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '自增id',
  `biz_date` timestamp NULL DEFAULT NULL COMMENT '统计日期',
  `area_code` varchar(20) DEFAULT NULL COMMENT '区域代码',
  `area_name` varchar(255) DEFAULT NULL COMMENT '区域名称',
  `parent_area_code` varchar(20) DEFAULT NULL COMMENT '上级区域代码',
  `case_accept_count` int(10) DEFAULT '0' COMMENT '已处理数',
  `case_handle_count` int(10) DEFAULT '0' COMMENT '已处理数',
  `case_refuse_count` int(10) DEFAULT '0' COMMENT '不受理',
  `overdue_unresponse_count` int(10) DEFAULT '0' COMMENT '超期未响应',
  `one_star` int(10) DEFAULT '0' COMMENT '1星数',
  `tow_star` int(10) DEFAULT '0' COMMENT '2星数',
  `three_star` int(10) DEFAULT '0' COMMENT '3星数',
  `four_star` int(10) DEFAULT '0' COMMENT '4星数',
  `five_star` int(10) DEFAULT '0' COMMENT '5星数',
  `case_fail_count` int(10) DEFAULT '0' COMMENT '调解失败数',
  `case_end_count` int(10) DEFAULT '0' COMMENT '结案数',
  `case_not_end_count` int(10) DEFAULT '0' COMMENT '未结案数',
  `status` varchar(2) DEFAULT '0' COMMENT '状态 0 正常 1 删除',
  `remark` varchar(1024) DEFAULT NULL COMMENT '备注',
  `create_user` varchar(36) DEFAULT NULL COMMENT '创建人',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_user` varchar(36) DEFAULT NULL COMMENT '修改人',
  `update_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  `version` int(11) DEFAULT '0' COMMENT '版本号',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3061 DEFAULT CHARSET=utf8 COMMENT='资源报表总览表';
	

CREATE TABLE `area_org_count_info` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '自增id',
  `biz_date` timestamp NULL DEFAULT NULL COMMENT '统计日期',
  `area_code` varchar(20) DEFAULT NULL COMMENT '区域代码',
  `area_name` varchar(255) DEFAULT NULL COMMENT '区域名称',
  `parent_area_code` varchar(20) DEFAULT NULL COMMENT '上级区域代码',
  `org_count` int(10) DEFAULT '0' COMMENT '机构数',
  `status` varchar(2) DEFAULT '0' COMMENT '状态 0 正常 1 删除',
  `remark` varchar(1024) DEFAULT NULL COMMENT '备注',
  `create_user` varchar(36) DEFAULT NULL COMMENT '创建人',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_user` varchar(36) DEFAULT NULL COMMENT '修改人',
  `update_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  `version` int(11) DEFAULT '0' COMMENT '版本号',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3316 DEFAULT CHARSET=utf8 COMMENT='机构数区域分布表';

CREATE TABLE `area_org_online_info` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '自增id',
  `biz_date` timestamp NULL DEFAULT NULL COMMENT '统计日期',
  `area_code` varchar(20) DEFAULT NULL COMMENT '区域代码',
  `area_name` varchar(255) DEFAULT NULL COMMENT '区域名称',
  `parent_area_code` varchar(20) DEFAULT NULL COMMENT '上级区域代码',
  `org_type_code` varchar(20) DEFAULT NULL COMMENT '机构类型代码',
  `org_type_name` varchar(150) DEFAULT NULL COMMENT '机构类型名称',
  `org_count` int(10) DEFAULT '0' COMMENT '机构数',
  `online_count` int(10) DEFAULT NULL COMMENT '上线数',
  `status` varchar(2) DEFAULT '0' COMMENT '状态 0 正常 1 删除',
  `remark` varchar(1024) DEFAULT NULL COMMENT '备注',
  `create_user` varchar(36) DEFAULT NULL COMMENT '创建人',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_user` varchar(36) DEFAULT NULL COMMENT '修改人',
  `update_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  `version` int(11) DEFAULT '0' COMMENT '版本号',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3752 DEFAULT CHARSET=utf8 COMMENT='机构上线日统计表';


CREATE TABLE `org_mediation_statistic_daily` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '自增id',
  `biz_date` timestamp NULL DEFAULT NULL COMMENT '统计日期',
  `area_code` varchar(20) DEFAULT NULL COMMENT '所在区域代码',
  `area_full_name` varchar(255) DEFAULT NULL COMMENT '所在区域名称',
  `parent_area_code` varchar(20) DEFAULT NULL COMMENT '上级区域代码',
  `org_code` varchar(20) DEFAULT NULL COMMENT '机构名称',
  `org_name` varchar(255) DEFAULT NULL COMMENT '机构代码',
  `user_name` varchar(100) DEFAULT NULL COMMENT '用户姓名,调解员独有',
  `user_id` varchar(20) DEFAULT NULL COMMENT '用户ID,调解员独有',
  `ability` varchar(100) DEFAULT NULL COMMENT '擅长领域,调解员独有',
  `mediate_code` varchar(50) DEFAULT NULL COMMENT '调解类型代码,机构独有',
  `mediate_name` varchar(256) DEFAULT NULL COMMENT '调解类型名称,机构独有',
  `mediator_count` int(10) DEFAULT '0' COMMENT '调解员数,机构独有',
  `mediator_online_count` int(10) DEFAULT '0' COMMENT '上线调解员数,机构独有',
  `case_apply_count` int(10) DEFAULT '0' COMMENT '收案数',
  `case_accept_count` int(10) DEFAULT '0' COMMENT '受理数',
  `case_not_end_count` int(10) DEFAULT '0' COMMENT '存案数',
  `case_start_count` int(10) DEFAULT '0' COMMENT '调解中数',
  `case_end_count` int(10) DEFAULT '0' COMMENT '结案数',
  `one_star` int(10) DEFAULT '0' COMMENT '1星数',
  `tow_star` int(10) DEFAULT '0' COMMENT '2星数',
  `three_star` int(10) DEFAULT '0' COMMENT '3星数',
  `four_star` int(10) DEFAULT '0' COMMENT '4星数',
  `five_star` int(10) DEFAULT '0' COMMENT '5星数',
  `case_success_count` int(10) DEFAULT '0' COMMENT '调解成功数',
  `case_fail_count` int(10) DEFAULT '0' COMMENT '调解失败数',
  `meeting_case_count` int(10) DEFAULT '0' COMMENT '预约会议案件数,机构独有',
  `doc_case_count` int(10) DEFAULT '0' COMMENT '发起文书案件数,机构独有',
  `mediate_time` int(10) DEFAULT '0' COMMENT '调解时长(秒),机构独有',
  `success_rate` int(10) DEFAULT '0' COMMENT '成功率',
  `satisfaction_rate` int(10) DEFAULT '0' COMMENT '满意度',
  `handle_rate` int(10) DEFAULT '0' COMMENT '处理率',
  `data_type` varchar(20) DEFAULT NULL COMMENT '数据类型（机构/调解员）',
  `status` varchar(2) DEFAULT '0' COMMENT '状态 0 正常 1 删除',
  `remark` varchar(1024) DEFAULT NULL COMMENT '备注',
  `create_user` varchar(36) DEFAULT NULL COMMENT '创建人',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_user` varchar(36) DEFAULT NULL COMMENT '修改人',
  `update_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  `version` int(11) DEFAULT '0' COMMENT '版本号',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=35050 DEFAULT CHARSET=utf8 COMMENT='机构/调解员日统计表';


			CREATE TABLE `area_case_accept_count_temp` (
			`id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '自增id',
			`area_code` varchar(20) DEFAULT NULL COMMENT '区域代码',
			`case_accept_count` int(10) DEFAULT '0' COMMENT '受理数',
			PRIMARY KEY (`id`)
			) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='区域受理数临时表';
			
			CREATE TABLE `area_case_end_count_temp` (
			`id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '自增id',
			`area_code` varchar(20) DEFAULT NULL COMMENT '区域代码',
			`case_end_count` int(10) DEFAULT '0' COMMENT '结案数',
			PRIMARY KEY (`id`)
			) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='区域结案数临时表';
			
			CREATE TABLE `area_case_fail_count_temp` (
			`id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '自增id',
			`area_code` varchar(20) DEFAULT NULL COMMENT '区域代码',
			`case_fail_count` int(10) DEFAULT '0' COMMENT '调解失败数',
			PRIMARY KEY (`id`)
			) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='区域调解失败数临时表';
	

			CREATE TABLE `area_case_handle_count_temp` (
			`id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '自增id',
			`area_code` varchar(20) DEFAULT NULL COMMENT '区域代码',
			`case_handle_count` int(10) DEFAULT '0' COMMENT '已处理数',
			PRIMARY KEY (`id`)
			) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='区域已处理数临时表';

			CREATE TABLE `area_case_not_end_count_temp` (
			`id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '自增id',
			`area_code` varchar(20) DEFAULT NULL COMMENT '区域代码',
			`case_not_end_count` int(10) DEFAULT '0' COMMENT '未结案数',
			PRIMARY KEY (`id`)
			) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='区域未结案数临时表';
	

			CREATE TABLE `area_case_refuse_count_temp` (
			`id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '自增id',
			`area_code` varchar(20) DEFAULT NULL COMMENT '区域代码',
			`case_refuse_count` int(10) DEFAULT '0' COMMENT '不受理数',
			PRIMARY KEY (`id`)
			) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='区域不受理数临时表';
	

			CREATE TABLE `area_case_response_count_temp` (
			`id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '自增id',
			`area_code` varchar(20) DEFAULT NULL COMMENT '区域代码',
			`parent_area_code` varchar(20) DEFAULT NULL COMMENT '上级区域代码',
			`unresponse_count` int(10) DEFAULT '0' COMMENT '未响应数',
			`overdue_unresponse_count` int(10) DEFAULT '0' COMMENT '超期未响应',
			`status` varchar(2) DEFAULT '0' COMMENT '状态 0 正常 1 删除',
			`remark` varchar(1024) DEFAULT NULL COMMENT '备注',
			`create_user` varchar(36) DEFAULT NULL COMMENT '创建人',
			`create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
			`update_user` varchar(36) DEFAULT NULL COMMENT '修改人',
			`update_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
			COMMENT '更新时间',
			`version` int(11) DEFAULT '0' COMMENT '版本号',
			PRIMARY KEY (`id`)
			) ENGINE=InnoDB AUTO_INCREMENT=54 DEFAULT CHARSET=utf8
			COMMENT='区域案件未响应数临时表';
		
			

			CREATE TABLE `area_org_count_info_temp` (
			`id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '自增id',
			`biz_date` timestamp NULL DEFAULT NULL COMMENT '统计日期',
			`area_code` varchar(20) DEFAULT NULL COMMENT '区域代码',
			`area_name` varchar(255) DEFAULT NULL COMMENT '区域名称',
			`parent_area_code` varchar(20) DEFAULT NULL COMMENT '上级区域代码',
			`org_count` int(10) DEFAULT '0' COMMENT '机构数',
			`status` varchar(2) DEFAULT '0' COMMENT '状态 0 正常 1 删除',
			`remark` varchar(1024) DEFAULT NULL COMMENT '备注',
			`create_user` varchar(36) DEFAULT NULL COMMENT '创建人',
			`create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
			`update_user` varchar(36) DEFAULT NULL COMMENT '修改人',
			`update_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
			COMMENT '更新时间',
			`version` int(11) DEFAULT '0' COMMENT '版本号',
			PRIMARY KEY (`id`)
			) ENGINE=InnoDB AUTO_INCREMENT=272 DEFAULT CHARSET=utf8
			COMMENT='机构数区域分布临时表';
		

			CREATE TABLE `area_org_online_info_temp` (
			`id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '自增id',
			`biz_date` timestamp NULL DEFAULT NULL COMMENT '统计日期',
			`area_code` varchar(20) DEFAULT NULL COMMENT '区域代码',
			`area_name` varchar(255) DEFAULT NULL COMMENT '区域名称',
			`parent_area_code` varchar(20) DEFAULT NULL COMMENT '上级区域代码',
			`org_type_code` varchar(20) DEFAULT NULL COMMENT '机构类型代码',
			`org_type_name` varchar(150) DEFAULT NULL COMMENT '机构类型名称',
			`org_count` int(10) DEFAULT '0' COMMENT '机构数',
			`online_count` int(10) DEFAULT NULL COMMENT '上线数',
			`status` varchar(2) DEFAULT '0' COMMENT '状态 0 正常 1 删除',
			`remark` varchar(1024) DEFAULT NULL COMMENT '备注',
			`create_user` varchar(36) DEFAULT NULL COMMENT '创建人',
			`create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
			`update_user` varchar(36) DEFAULT NULL COMMENT '修改人',
			`update_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
			COMMENT '更新时间',
			`version` int(11) DEFAULT '0' COMMENT '版本号',
			PRIMARY KEY (`id`)
			) ENGINE=InnoDB AUTO_INCREMENT=294 DEFAULT CHARSET=utf8
			COMMENT='机构上线日统计临时表';
		

			CREATE TABLE `area_org_temp` (
			`id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '自增id',
			`area_code` varchar(20) DEFAULT NULL COMMENT '区域代码',
			`area_name` varchar(255) DEFAULT NULL COMMENT '区域名称',
			`parent_area_code` varchar(20) DEFAULT NULL COMMENT '上级区域代码',
			`org_code` varchar(20) DEFAULT NULL COMMENT '机构代码',
			`org_name` varchar(255) DEFAULT NULL COMMENT '机构名称',
			`type_code` varchar(50) DEFAULT NULL COMMENT '机构类型代码',
			`type_name` varchar(256) DEFAULT NULL COMMENT '机构类型名称',
			`status` varchar(2) DEFAULT '0' COMMENT '状态 0 正常 1 删除',
			PRIMARY KEY (`id`)
			) ENGINE=InnoDB AUTO_INCREMENT=256 DEFAULT CHARSET=utf8
			COMMENT='机构区域中间表';
		

			CREATE TABLE `area_stars_temp` (
			`id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '自增id',
			`area_code` varchar(20) DEFAULT NULL COMMENT '区域代码',
			`one_star` int(10) DEFAULT '0' COMMENT '1星数',
			`tow_star` int(10) DEFAULT '0' COMMENT '2星数',
			`three_star` int(10) DEFAULT '0' COMMENT '3星数',
			`four_star` int(10) DEFAULT '0' COMMENT '4星数',
			`five_star` int(10) DEFAULT '0' COMMENT '5星数',
			PRIMARY KEY (`id`)
			) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='区域星星数临时表';
		

			CREATE TABLE `areas_temp` (
			`id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '自增id',
			`code` varchar(16) NOT NULL COMMENT '地区代码',
			`name` varchar(500) DEFAULT NULL COMMENT '地区名称',
			`full_name` varchar(1024) DEFAULT NULL COMMENT '加上父级的名称和自己的名称',
			`level` int(1) DEFAULT NULL COMMENT '等级',
			`parent_code` varchar(20) DEFAULT NULL COMMENT '父级地区代码',
			`status` varchar(2) CHARACTER SET utf32 DEFAULT '0' COMMENT '状态 0 正常 1 删除',
			`remark` varchar(1024) DEFAULT NULL COMMENT '备注',
			`create_user` varchar(32) DEFAULT NULL COMMENT '创建人',
			`create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
			`update_user` varchar(32) DEFAULT NULL COMMENT '修改人',
			`update_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
			COMMENT '更新时间',
			`version` int(11) DEFAULT '0' COMMENT '版本号',
			PRIMARY KEY (`id`),
			UNIQUE KEY `unique_index_areas_code` (`code`) USING BTREE,
			KEY `index_parent_code` (`parent_code`) USING BTREE
			) ENGINE=InnoDB AUTO_INCREMENT=2098807 DEFAULT CHARSET=utf8
			COMMENT='地域临时表';
		

			CREATE TABLE `law_case_handle_status_temp` (
			`id` bigint(20) NOT NULL AUTO_INCREMENT,
			`mediation_type` varchar(100) DEFAULT NULL COMMENT '调解类型(人民调解，行政调解)',
			`creator_id` bigint(20) DEFAULT NULL COMMENT '案件录入人id',
			`creator_type` varchar(100) DEFAULT NULL COMMENT '案件录入人的身份',
			`case_no` varchar(50) DEFAULT NULL COMMENT '案件编号',
			`video_id` bigint(20) DEFAULT NULL COMMENT '视频表id',
			`law_case_status` varchar(100) DEFAULT NULL COMMENT '状态码(05纠纷被拒绝受理等)',
			`case_progress` varchar(100) DEFAULT NULL COMMENT '案件进度',
			`disputes_id` bigint(20) DEFAULT NULL COMMENT '咨询纠纷id，咨询转立案存入该值',
			`dispute_type_code` varchar(256) DEFAULT NULL COMMENT '纠纷类型字典表code',
			`dispute_type` varchar(50) DEFAULT NULL COMMENT '纠纷类型',
			`prov_code` varchar(255) DEFAULT NULL COMMENT '省code',
			`city_code` varchar(255) DEFAULT NULL COMMENT '市code',
			`area_code` varchar(255) DEFAULT NULL COMMENT '区code',
			`street_code` varchar(255) DEFAULT NULL COMMENT '街道code',
			`prov_name` varchar(255) DEFAULT NULL COMMENT '省名称',
			`city_name` varchar(255) DEFAULT NULL COMMENT '市名称',
			`area_name` varchar(255) DEFAULT NULL COMMENT '区名称',
			`street_name` varchar(255) DEFAULT NULL COMMENT '街道名称',
			`address` varchar(255) DEFAULT '' COMMENT '详细地址',
			`appeal` text COMMENT '申请人诉求',
			`dispute_content` text COMMENT '纠纷描述',
			`org_id` bigint(20) DEFAULT NULL COMMENT '机构id',
			`org_name` varchar(255) DEFAULT NULL COMMENT '机构名称',
			`org_area_code` varchar(255) DEFAULT NULL COMMENT '机构地区code',
			`mediator_id` bigint(20) DEFAULT NULL COMMENT '调解员id',
			`mediator_name` varchar(255) DEFAULT NULL COMMENT '调解员名称',
			`origin` varchar(100) DEFAULT NULL COMMENT '案件来源。本平台录入；第三方平台导入。网上立案系统导入，律师平台导入',
			`org_confirm` tinyint(1) DEFAULT '0' COMMENT '机构业务负责人是否已经确认的字段(0：未确认 1：已确认)',
			`start_time` timestamp NULL DEFAULT NULL COMMENT '调解开始时间',
			`end_time` timestamp NULL DEFAULT NULL COMMENT '调解结束时间',
			`case_complete_time` timestamp NULL DEFAULT NULL COMMENT '案件完成时间',
			`tab` varchar(255) DEFAULT NULL COMMENT '重新分配的标签',
			`tab_detail` longtext COMMENT '重新分配的详细内容',
			`sms_off` tinyint(1) DEFAULT '0' COMMENT '选择性短信发送功能 0为发送，1为不发送',
			`status` tinyint(1) NOT NULL DEFAULT '0' COMMENT '状态',
			`remark` varchar(1024) DEFAULT NULL COMMENT '备注',
			`create_user` varchar(36) DEFAULT NULL COMMENT '创建人名字',
			`create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
			`update_user` varchar(36) DEFAULT NULL COMMENT '更新人名字',
			`update_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
			COMMENT '更新时间',
			`version` int(11) DEFAULT '0' COMMENT '版本',
			`community_code` varchar(255) DEFAULT NULL COMMENT '社区code',
			`community_name` varchar(255) DEFAULT NULL COMMENT '社区名称',
			`docket` tinyint(1) DEFAULT '0' COMMENT '是否立案标识',
			PRIMARY KEY (`id`),
			KEY `idx_law_case_status` (`law_case_status`) USING BTREE,
			KEY `idx_case_progress` (`case_progress`) USING BTREE,
			KEY `idx_org_id` (`org_id`) USING BTREE,
			KEY `idx_mediator_id` (`mediator_id`) USING BTREE
			) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='案件信息已处理状态临时表';
		

			CREATE TABLE `mediator_statistic_apply_count_temp` (
			`id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '自增id',
			`biz_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE
			CURRENT_TIMESTAMP COMMENT '统计日期',
			`org_code` varchar(20) DEFAULT NULL COMMENT '机构名称',
			`user_id` varchar(20) DEFAULT NULL COMMENT '用户ID',
			`case_apply_count` int(10) DEFAULT '0' COMMENT '收案数',
			`create_user` varchar(36) DEFAULT NULL COMMENT '创建人',
			`create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
			PRIMARY KEY (`id`)
			) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='调解员收案统计表';
		

			CREATE TABLE `mediator_statistic_case_progress_count_temp` (
			`id` bigint(20) NOT NULL AUTO_INCREMENT,
			`org_id` bigint(20) DEFAULT NULL COMMENT '机构id',
			`mediator_id` bigint(20) DEFAULT NULL COMMENT '调解员id',
			`progress_status` varchar(30) DEFAULT NULL COMMENT '进度',
			`count` bigint(20) DEFAULT '0' COMMENT '数量',
			`create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
			PRIMARY KEY (`id`)
			) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='调解员日统计各进度案件数表';
		

			CREATE TABLE `mediator_statistic_daily_temp` (
			`id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '自增id',
			`biz_date` timestamp NULL DEFAULT NULL COMMENT '统计日期',
			`area_code` varchar(20) DEFAULT NULL COMMENT '所在区域代码',
			`area_full_name` varchar(255) DEFAULT NULL COMMENT '所在区域名称',
			`parent_area_code` varchar(20) DEFAULT NULL COMMENT '上级区域代码',
			`org_code` varchar(20) DEFAULT NULL COMMENT '机构名称',
			`org_name` varchar(255) DEFAULT NULL COMMENT '机构代码',
			`user_name` varchar(100) DEFAULT NULL COMMENT '用户姓名',
			`user_id` varchar(20) DEFAULT NULL COMMENT '用户ID',
			`ability` varchar(100) DEFAULT NULL COMMENT '擅长领域',
			`mediate_code` varchar(50) DEFAULT NULL COMMENT '调解类型代码',
			`mediate_name` varchar(256) DEFAULT NULL COMMENT '调解类型名称',
			`mediator_count` int(10) DEFAULT '0' COMMENT '调解员数',
			`case_apply_count` int(10) DEFAULT '0' COMMENT '收案数',
			`case_accept_count` int(10) DEFAULT '0' COMMENT '受理数',
			`case_not_end_count` int(10) DEFAULT '0' COMMENT '存案数',
			`case_start_count` int(10) DEFAULT '0' COMMENT '调解中数',
			`case_end_count` int(10) DEFAULT '0' COMMENT '结案数',
			`one_star` int(10) DEFAULT '0' COMMENT '1星数',
			`tow_star` int(10) DEFAULT '0' COMMENT '2星数',
			`three_star` int(10) DEFAULT '0' COMMENT '3星数',
			`four_star` int(10) DEFAULT '0' COMMENT '4星数',
			`five_star` int(10) DEFAULT '0' COMMENT '5星数',
			`case_success_count` int(10) DEFAULT '0' COMMENT '调解成功数',
			`case_fail_count` int(10) DEFAULT '0' COMMENT '调解失败数',
			`success_rate` int(10) DEFAULT '0' COMMENT '成功率',
			`satisfaction_rate` int(10) DEFAULT '0' COMMENT '满意度',
			`handle_rate` int(10) DEFAULT '0' COMMENT '处理率',
			`mediate_time` int(10) DEFAULT '0' COMMENT '调解时长(秒)',
			`data_type` varchar(20) DEFAULT NULL COMMENT '数据类型（机构/调解员）',
			`status` varchar(2) DEFAULT '0' COMMENT '状态 0 正常 1 删除',
			`remark` varchar(1024) DEFAULT NULL COMMENT '备注',
			`create_user` varchar(36) DEFAULT NULL COMMENT '创建人',
			`create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
			`update_user` varchar(36) DEFAULT NULL COMMENT '修改人',
			`update_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
			COMMENT '更新时间',
			`version` int(11) DEFAULT '0' COMMENT '版本号',
			PRIMARY KEY (`id`)
			) ENGINE=InnoDB AUTO_INCREMENT=512 DEFAULT CHARSET=utf8
			COMMENT='调解员日统计临时表';
	

			CREATE TABLE `org_statistic_daily_temp` (
			`id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '自增id',
			`biz_date` timestamp NULL DEFAULT NULL COMMENT '统计日期',
			`area_code` varchar(20) DEFAULT NULL COMMENT '所在区域代码',
			`area_full_name` varchar(255) DEFAULT NULL COMMENT '所在区域名称',
			`parent_area_code` varchar(20) DEFAULT NULL COMMENT '上级区域代码',
			`org_code` varchar(20) DEFAULT NULL COMMENT '机构名称',
			`org_name` varchar(255) DEFAULT NULL COMMENT '机构代码',
			`user_name` varchar(100) DEFAULT NULL COMMENT '用户姓名',
			`user_id` varchar(20) DEFAULT NULL COMMENT '用户ID',
			`ability` varchar(100) DEFAULT NULL COMMENT '擅长领域',
			`mediate_code` varchar(50) DEFAULT NULL COMMENT '调解类型代码',
			`mediate_name` varchar(256) DEFAULT NULL COMMENT '调解类型名称',
			`mediator_count` int(10) DEFAULT '0' COMMENT '调解员数',
			`mediator_online_count` int(10) DEFAULT '0' COMMENT '上线调解员数',
			`case_apply_count` int(10) DEFAULT '0' COMMENT '收案数',
			`case_accept_count` int(10) DEFAULT '0' COMMENT '受理数',
			`case_not_end_count` int(10) DEFAULT '0' COMMENT '存案数',
			`case_start_count` int(10) DEFAULT '0' COMMENT '调解中数',
			`case_end_count` int(10) DEFAULT '0' COMMENT '结案数',
			`one_star` int(10) DEFAULT '0' COMMENT '1星数',
			`tow_star` int(10) DEFAULT '0' COMMENT '2星数',
			`three_star` int(10) DEFAULT '0' COMMENT '3星数',
			`four_star` int(10) DEFAULT '0' COMMENT '4星数',
			`five_star` int(10) DEFAULT '0' COMMENT '5星数',
			`case_success_count` int(10) DEFAULT '0' COMMENT '调解成功数',
			`case_fail_count` int(10) DEFAULT '0' COMMENT '调解失败数',
			`meeting_case_count` int(10) DEFAULT '0' COMMENT '预约会议案件数,机构独有',
			`doc_case_count` int(10) DEFAULT '0' COMMENT '发起文书案件数,机构独有',
			`success_rate` int(10) DEFAULT '0' COMMENT '成功率',
			`satisfaction_rate` int(10) DEFAULT '0' COMMENT '满意度',
			`handle_rate` int(10) DEFAULT '0' COMMENT '处理率',
			`mediate_time` int(10) DEFAULT '0' COMMENT '调解时长(秒)',
			`data_type` varchar(20) DEFAULT NULL COMMENT '数据类型（机构/调解员）',
			`status` varchar(2) DEFAULT '0' COMMENT '状态 0 正常 1 删除',
			`remark` varchar(1024) DEFAULT NULL COMMENT '备注',
			`create_user` varchar(36) DEFAULT NULL COMMENT '创建人',
			`create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
			`update_user` varchar(36) DEFAULT NULL COMMENT '修改人',
			`update_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
			COMMENT '更新时间',
			`version` int(11) DEFAULT '0' COMMENT '版本号',
			PRIMARY KEY (`id`)
			) ENGINE=InnoDB AUTO_INCREMENT=2551 DEFAULT CHARSET=utf8
			COMMENT='机构日统计临时表';
	
