CREATE TABLE `mediation_sex_and_age_statistics` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '自增id',
  `biz_date` timestamp NULL DEFAULT NULL COMMENT '统计日期',
  `area_code` varchar(20) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '所在区域代码',
  `parent_area_code` varchar(20) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '上级区域代码',
  `male` int(11) DEFAULT '0' COMMENT '男调解员',
  `female` int(11) DEFAULT '0' COMMENT '女调解员',
  `unknown_sex` int(11) DEFAULT '0' COMMENT '性别未知调解员',
  `less_twenty` int(11) DEFAULT '0' COMMENT '小于等于20岁的调解员',
  `less_forty` int(11) DEFAULT '0' COMMENT '21-40岁的调解员',
  `less_sixty` int(11) DEFAULT '0' COMMENT '41-60岁的调解员',
  `more_sixty` int(11) DEFAULT '0' COMMENT '60岁以上的调解员',
  `status` varchar(2) CHARACTER SET utf32 COLLATE utf32_general_ci DEFAULT '0' COMMENT '状态 0 正常 1 删除',
  `remark` varchar(1024) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '备注',
  `create_user` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '创建人',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_user` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '修改人',
  `update_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  `version` int(11) DEFAULT '0' COMMENT '版本号',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=556 DEFAULT CHARSET=utf8 COMMENT='调解员年龄性别统计表';


CREATE TABLE `medi_info_temp` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '自增',
  `user_id` bigint(20) NOT NULL COMMENT '用户id',
  `organization_id` bigint(20) DEFAULT NULL COMMENT '机构id',
  `province_code` varchar(16) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '省',
  `city_code` varchar(16) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '市代码',
  `area_code` varchar(16) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '区代码',
  `street_code` varchar(16) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '街道代码',
  `community_code` varchar(16) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '社区代码',
  `current_area_code` varchar(20) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '所在区域代码',
  `parent_area_code` varchar(20) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '上级区域代码',
  `id_card` varchar(20) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '身份证',
  `birth_year` varchar(10) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '出生年份',
  `sex` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '性别',
  `create_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=317 DEFAULT CHARSET=utf8 COMMENT='调解信息表';