package com.beiming.pigeons.api.producer;

import com.beiming.pigeons.api.constants.DeliverTypeConstants;
import com.google.common.base.Charsets;
import com.google.common.base.MoreObjects;
import java.io.Serializable;

/**
 */
public class MessageDto implements Serializable {

  /**
   *
   */
  private String topic;

  private String tags;

  /**
   * 投递方式
   */
  private Integer deliverType;

  /**
   * 接收者地址 1、rocketmq 名称 2、消息接收方的地址
   */
  private String receiverAddress;

  /**
   * 消息体
   */
  private byte[] receiverParam;

  private String callbackAddress;

  /**
   * 关键字
   */
  private String keyword;

  /**
   * 用于调用链跟踪Id
   */
  private String requestId;

  private String clientIp;

  private String groupName;

  private String sourcePlatform;


  public Integer getDeliverType() {
    return deliverType;
  }

  public void setDeliverType(Integer deliverType) {

    this.deliverType = deliverType;
  }

  public String getTopic() {
    return topic;
  }

  public void setTopic(String topic) {

    this.topic = topic;
  }

  public String getReceiverAddress() {
    return receiverAddress;
  }

  public void setReceiverAddress(String receiverAddress) {
    this.receiverAddress = receiverAddress;
  }

  public byte[] getReceiverParam() {
    return receiverParam;
  }

  public void setReceiverParam(byte[] receiverParam) {
    this.receiverParam = receiverParam;
  }

  public String getCallbackAddress() {
    return callbackAddress;
  }

  public void setCallbackAddress(String callbackAddress) {
    this.callbackAddress = callbackAddress;
  }

  public String getKeyword() {
    return keyword;
  }

  public void setKeyword(String keyword) {
    this.keyword = keyword;
  }

  public String getRequestId() {
    return requestId;
  }

  public void setRequestId(String requestId) {
    this.requestId = requestId;
  }

  public String getTags() {
    return tags;
  }

  public void setTags(String tags) {
    this.tags = tags;
  }

  public String getClientIp() {
    return clientIp;
  }

  public void setClientIp(String clientIp) {
    this.clientIp = clientIp;
  }

  public String getGroupName() {
    return groupName;
  }

  public void setGroupName(String groupName) {
    this.groupName = groupName;
  }

  public String getSourcePlatform() {
    return sourcePlatform;
  }

  public void setSourcePlatform(String sourcePlatform) {
    this.sourcePlatform = sourcePlatform;
  }

  @Override
  public String toString() {
    String receiverParamStr = null;
    try {
      if (deliverType != null && DeliverTypeConstants.ROCKET_MQ == deliverType) {
        receiverParamStr = new String(receiverParam, Charsets.UTF_8);
      } else {
        receiverParamStr = "字节码数据";
      }
    } catch (Exception e) {

    }
    return MoreObjects.toStringHelper(this)
        .add("topic", topic)
        .add("tags", tags)
        .add("deliverType", deliverType)
        .add("receiverAddress", receiverAddress)
        .add("receiverParam", receiverParamStr)
        .add("callbackAddress", callbackAddress)
        .add("keyword", keyword)
        .add("requestId", requestId)
        .add("clientIp", clientIp)
        .add("groupName", groupName)
        .add("sourcePlatform", sourcePlatform)
        .toString();
  }
}
