package com.beiming.pigeons.api.producer.hessian;

import com.beiming.framework.domain.DubboResult;
import com.beiming.pigeons.api.constants.DeliverTypeConstants;
import java.io.Serializable;
import org.apache.commons.lang3.StringUtils;

/**
 */
public class HessianRpcProducerService {

  /**
   * 主题
   */
  private String topic;
  /**
   * 消息接收方adapter地址
   */
  private String receiverAdapterAddress;
  /**
   * 消息接收方spring bean 名称
   */
  private String receiverServiceName;
  /**
   * 接收方方法名称
   */
  private String receiverMethodName;
  /**
   * 回调地址adapter地址
   */
  private String callbackAdapterAddress;
  /**
   * 回调 spring bean 名称
   */
  private String callbackServiceName;

  /**
   * 回调 方法名称
   */
  private String callbackMethodName;

  /**
   * 发送方client bean
   */
  private HessianProducerClient producerClient;

  public DubboResult<String> sendMsg(Serializable receiverParam) {
    SenderMessageDto messageDto = new SenderMessageDto();
    if (StringUtils.isNotEmpty(getCallbackAdapterAddress())) {
      messageDto.setCallbackAddress(
          getCallbackAdapterAddress() + "$$" + getCallbackServiceName() + "."
              + getCallbackMethodName());
    }
    messageDto.setReceiverAddress(
        getReceiverAdapterAddress() + "$$" + getReceiverServiceName() + "."
            + getReceiverMethodName());
    messageDto.setDeliverType(getDeliverType());
    messageDto.setTopic(getTopic());
    messageDto.setReceiverParam(receiverParam);
    return getProducerClient().sendMessage(messageDto);
  }

  private boolean needCallback() {
    return StringUtils.isNotEmpty(getCallbackAdapterAddress())
        && StringUtils.isNotEmpty(callbackServiceName)
        && StringUtils.isNotEmpty(callbackMethodName);
  }

  public String getCallbackServiceName() {
    return callbackServiceName;
  }

  public void setCallbackServiceName(String callbackServiceName) {
    this.callbackServiceName = callbackServiceName;
  }

  public String getCallbackMethodName() {
    return callbackMethodName;
  }

  public void setCallbackMethodName(String callbackMethodName) {
    this.callbackMethodName = callbackMethodName;
  }

  public String getReceiverAdapterAddress() {
    return receiverAdapterAddress;
  }

  public Integer getDeliverType() {
    return DeliverTypeConstants.HESSIAN_RPC;
  }


  public String getTopic() {
    return topic;
  }

  public void setTopic(String topic) {
    this.topic = topic;
  }

  public String getReceiverServiceName() {
    return receiverServiceName;
  }

  public String getReceiverMethodName() {
    return receiverMethodName;
  }

  public void setReceiverMethodName(String receiverMethodName) {
    this.receiverMethodName = receiverMethodName;
  }

  public String getCallbackAdapterAddress() {
    return callbackAdapterAddress;
  }

  public void setCallbackAdapterAddress(String callbackAdapterAddress) {
    this.callbackAdapterAddress = callbackAdapterAddress;
  }

  public void setReceiverAdapterAddress(String receiverAdapterAddress) {
    this.receiverAdapterAddress = receiverAdapterAddress;
  }

  public HessianProducerClient getProducerClient() {
    return producerClient;
  }

  public void setProducerClient(HessianProducerClient producerClient) {
    this.producerClient = producerClient;
  }

  public void setReceiverServiceName(String receiverServiceName) {
    this.receiverServiceName = receiverServiceName;
  }
}
