package com.beiming.pigeons.api.producer.rocketmq;

import com.beiming.framework.context.AppNameContextHolder;
import com.beiming.framework.domain.PlatformConfig;
import com.beiming.framework.util.RequestIdUtils;
import com.beiming.pigeons.api.constants.KangarooConstants;
import com.beiming.pigeons.api.exception.KangarooException;
import com.beiming.pigeons.api.utils.JsonSerializeUtil;
import com.google.common.base.MoreObjects;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.commons.lang3.StringUtils;
import org.apache.rocketmq.common.message.Message;

/**
 *
 */
public class RocketMessageDto implements Serializable {

  private final String topic;

  private final String key;

  private final Object data;

  private final Message message;

  private final String tags;

  //    private Object data;
  public RocketMessageDto(String topic, String key, Object data) {
    this(topic, "", key, data);
  }

  public RocketMessageDto(String topic, String tags, String key, Object data) {
//        super(topic, tags, RocketMessageUtil.toByteArray(object));
    if (StringUtils.isEmpty(topic)) {
      throw new KangarooException("传输的消息主题不能为空");
    }
    if (StringUtils.isEmpty(key)) {
      throw new KangarooException("传输的消息关键字不能为空");
    }
    String keyTrim = key.trim();
    if (StringUtils.contains(keyTrim, " ")) {
      throw new KangarooException("传输的消息关键字不能包含空格");
    }
    if (data == null) {
      throw new KangarooException("传输的消息体数据不能为空");
    }
    if (StringUtils.isEmpty(PlatformConfig.getPlatform())) {
      throw new KangarooException("消息的平台标识不能为空");
    }
    if (StringUtils.isEmpty(PlatformConfig.getSystem())) {
      throw new KangarooException("消息的系统标识不能为空");
    }
    String appName = AppNameContextHolder.getAppName();
    if (StringUtils.isEmpty(appName)) {
      throw new KangarooException("appName不能为空");
    }
    String requestId = RequestIdUtils.generateNextRequestId();
    Message message = new Message();

    try {
      Field field = data.getClass().getSuperclass().getDeclaredField("appName");
      if (field == null) {
        throw new KangarooException("必须继承BaseMessageDto");
      }
      Method m = m = data.getClass().getMethod("setAppName", String.class);
      m.invoke(data, appName);
    } catch (NoSuchFieldException e) {
      e.printStackTrace();
    } catch (NoSuchMethodException e) {
      e.printStackTrace();
    } catch (IllegalAccessException e) {
      e.printStackTrace();
    } catch (InvocationTargetException e) {
      e.printStackTrace();
    }

    message.setKeys(keyTrim);
    message.setTags(tags);
    message.setTopic(topic);
    message.setTags(tags);
    message.setBody(JsonSerializeUtil.serialize(data));
    message.putUserProperty(KangarooConstants.ROCKET_REQUEST_ID_NAME, requestId);
    message.putUserProperty(KangarooConstants.PLATFORM_NAME, PlatformConfig.getPlatform());
    message.putUserProperty(KangarooConstants.SYSTEM_NAME, PlatformConfig.getSystem());
    this.message = message;
    this.tags = tags;
    this.data = data;
    this.topic = topic;
    this.key = key;
  }

  public Message getMessage() {
    return message;
  }

  public String getTopic() {
    return topic;
  }

  public String getKey() {
    return key;
  }

  public Object getData() {
    return data;
  }

  public String getTags() {
    return tags;
  }

  @Override
  public String toString() {
    return MoreObjects.toStringHelper(this)
        .add("topic", topic)
        .add("key", key)
        .add("data", data)
        .add("message", message)
        .add("tags", tags)
        .toString();
  }
}
