package com.beiming.pigeons.api.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Charsets;

public class JsonSerializeUtil {

  /**
   * 对象转数组
   */
  public static byte[] serialize(Object obj) {
    byte[] bytes = null;

    if (obj != null) {
      if (obj instanceof String) {
        String s = (String) obj;
        bytes = s.getBytes(Charsets.UTF_8);
      } else {
        bytes = JSONObject.toJSONString(obj).getBytes(Charsets.UTF_8);
      }
    }
    return bytes;
  }

  /**
   * 数组转对象
   */
  public static <T> T deserialize(byte[] bytes, Class<T> clazz) {
    T obj = null;

    if (bytes != null) {
      String objJson = new String(bytes, Charsets.UTF_8);
      if (clazz.equals(String.class)) {
        return (T) objJson;
      }
      return JSON.parseObject(objJson, clazz);
    }

    return obj;
  }


}
