/*
 * Decompiled with CFR 0.152.
 */
package com.beiming.pigeons.api.consumer.hessian;

import com.alibaba.fastjson.JSONObject;
import com.beiming.framework.domain.DubboResult;
import com.beiming.framework.domain.DubboResultBuilder;
import com.beiming.framework.enums.DubboResultCodeEnums;
import com.beiming.framework.exception.DubboBusinessException;
import com.beiming.framework.log.ActionLog;
import com.beiming.framework.log.ActionLoggerImpl;
import com.beiming.framework.util.RequestIdUtils;
import com.beiming.pigeons.api.consumer.ConsumerAdapter;
import com.beiming.pigeons.api.consumer.ReceiverMessageDto;
import com.beiming.pigeons.api.utils.HessianSerializeUtils;
import com.beiming.pigeons.api.utils.InetUtils;
import java.io.Closeable;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.MessageFormat;
import org.apache.commons.lang3.StringUtils;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.retry.ExponentialBackoffRetry;
import org.apache.curator.utils.CloseableUtils;
import org.apache.curator.x.discovery.ServiceDiscovery;
import org.apache.curator.x.discovery.ServiceDiscoveryBuilder;
import org.apache.curator.x.discovery.ServiceInstance;
import org.apache.curator.x.discovery.UriSpec;
import org.apache.curator.x.discovery.details.InstanceSerializer;
import org.apache.curator.x.discovery.details.JsonInstanceSerializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.remoting.caucho.HessianServiceExporter;

public class DefaultConsumerAdapter
implements ConsumerAdapter,
ApplicationContextAware,
DisposableBean {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultConsumerAdapter.class);
    private final ActionLoggerImpl actionLogger = ActionLoggerImpl.get();
    private static ApplicationContext applicationContext;
    private String appPort;
    private String zookeeperAddress;
    private String appName;
    private String contextPath;
    CuratorFramework client;
    ServiceDiscovery<Void> serviceDiscovery;

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        DefaultConsumerAdapter.applicationContext = applicationContext;
        this.serviceRegister();
    }

    private void serviceRegister() {
        if (StringUtils.isNotEmpty((CharSequence)this.zookeeperAddress)) {
            try {
                if (this.zookeeperAddress != null && this.appPort != null && this.appName != null) {
                    ExponentialBackoffRetry retryPolicy = new ExponentialBackoffRetry(1000, 3);
                    this.client = CuratorFrameworkFactory.builder().connectString(this.zookeeperAddress).sessionTimeoutMs(5000).connectionTimeoutMs(10000).retryPolicy((RetryPolicy)retryPolicy).namespace("pigeons").build();
                    this.client.start();
                    this.serviceStart();
                    LOGGER.info("\u670d\u52a1\u6ce8\u518c\u542f\u52a8\u5b8c\u6210============");
                }
            }
            catch (Exception e) {
                LOGGER.error("zookeeper \u670d\u52a1\u6ce8\u518c \u542f\u52a8\u5931\u8d25=================", (Throwable)e);
            }
        }
    }

    private void serviceStart() throws Exception {
        String[] beanNames = applicationContext.getBeanNamesForType(HessianServiceExporter.class);
        String beanName = null;
        if (beanNames == null || beanNames.length == 0) {
            LOGGER.error("\u6ca1\u6709\u6ce8\u518c\u6d88\u606f\u63a5\u6536\u8005====================");
        }
        if (beanNames.length == 1) {
            beanName = beanNames[0];
        } else {
            for (String beanNameTemp : beanNames) {
                if (!beanNameTemp.equals("/msg/consumer")) continue;
                beanName = "/msg/consumer";
                break;
            }
        }
        if (beanName == null) {
            LOGGER.error("\u6ca1\u6709\u627e\u5230\u5408\u9002\u7684\u6d88\u606f\u63a5\u6536bean=================");
        } else {
            String contextPathTemp;
            if (!beanName.startsWith("/")) {
                beanName = "/" + beanName;
            }
            String string = contextPathTemp = this.contextPath != null ? this.contextPath : "";
            if (!contextPathTemp.startsWith("/") && !StringUtils.isEmpty((CharSequence)contextPathTemp)) {
                contextPathTemp = "/" + contextPathTemp;
            }
            String ip = InetUtils.getLocalHostIp();
            String uri = "http://" + ip + ":" + this.appPort + contextPathTemp + beanName;
            ServiceInstance instance = ServiceInstance.builder().name(this.appName).uriSpec(new UriSpec(uri)).build();
            JsonInstanceSerializer serializer = new JsonInstanceSerializer(Void.class);
            this.serviceDiscovery = ServiceDiscoveryBuilder.builder(Void.class).client(this.client).serializer((InstanceSerializer)serializer).thisInstance(instance).basePath("msgServices").build();
            this.serviceDiscovery.start();
            LOGGER.info("\u672c\u670d\u52a1\u7684\u6d88\u606f\u63a5\u6536\u5730\u5740\u4e3a:" + uri);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DubboResult<byte[]> receiveMsg(ReceiverMessageDto messageDto) {
        DubboResult result;
        RequestIdUtils.setRequestId((String)messageDto.getRequestId());
        try {
            Object service = applicationContext.getBean(messageDto.getServiceName());
            result = service != null ? this.doInvoke(messageDto, service) : DubboResultBuilder.error((int)DubboResultCodeEnums.SOURCE_NOT_FOUND.value(), (String)MessageFormat.format("There is not bean named:{0}", messageDto.getServiceName()));
        }
        catch (DubboBusinessException e) {
            result = DubboResultBuilder.error((int)e.getCode(), (String)e.getBusinessMessage());
            LOGGER.info("Invoke fail result:{}", (Object)JSONObject.toJSONString(result));
        }
        finally {
            RequestIdUtils.removeRequestId();
            this.actionLogger.save();
        }
        return result;
    }

    private DubboResult<byte[]> doInvoke(ReceiverMessageDto messageDto, Object service) {
        Object methodParam = null;
        try {
            Class<?> clazz = service.getClass();
            methodParam = HessianSerializeUtils.deserialize(messageDto.getParam());
            Method method = clazz.getMethod(messageDto.getMethodName(), methodParam.getClass());
            Object consumerResult = method.invoke(service, methodParam);
            this.assignActionLogParams(messageDto, consumerResult);
            LOGGER.debug("\u4ece\u6d88\u606f\u7cfb\u7edf\u63a5\u6536\u6d88\u606f:\u8c03\u7528service:{}, \u8c03\u7528\u65b9\u6cd5:{}, \u8c03\u7528\u53c2\u6570\uff1a{}, \u8c03\u7528\u7ed3\u679c:{}", new Object[]{messageDto.getServiceName(), messageDto.getMethodName(), JSONObject.toJSONString((Object)HessianSerializeUtils.deserialize(messageDto.getParam())), JSONObject.toJSONString((Object)consumerResult)});
            return this.buildResult(consumerResult);
        }
        catch (NoSuchMethodException e) {
            LOGGER.error("method not fond", (Throwable)e);
            throw new DubboBusinessException(DubboResultCodeEnums.SOURCE_NOT_FOUND.value(), MessageFormat.format("No method found, method name:{0}, method type:{1}", messageDto.getMethodName(), methodParam.getClass()));
        }
        catch (Throwable t) {
            LOGGER.error("\u63a5\u6536\u6d88\u606f\u6267\u884c\u9519\u8bef, \u6d88\u606f\u4e3a:" + messageDto, t);
            throw new DubboBusinessException(DubboResultCodeEnums.INTERNAL_ERROR.value(), DubboResultCodeEnums.INTERNAL_ERROR.name());
        }
    }

    private void assignActionLogParams(ReceiverMessageDto messageDto, Object consumerResult) throws IOException {
        this.actionLogger.initialize();
        ActionLog actionLog = this.actionLogger.currentActionLog();
        if (null != actionLog) {
            actionLog.setRequestId(messageDto.getRequestId());
            actionLog.setAction(String.format("%s-%s", messageDto.getServiceName(), messageDto.getMethodName()));
            actionLog.setRequestContent(JSONObject.toJSONString((Object)HessianSerializeUtils.deserialize(messageDto.getParam())));
            actionLog.setResponseContent(JSONObject.toJSONString((Object)consumerResult));
        } else {
            LOGGER.info("\u6d88\u606f\u7cfb\u7edf\u5ba2\u6237\u7aef, actionLog \u4e3a\u7a7a");
        }
    }

    private DubboResult<byte[]> buildResult(Object consumerResult) throws IOException {
        if (consumerResult instanceof Serializable) {
            byte[] resultByteArray = HessianSerializeUtils.serialize(consumerResult);
            return DubboResultBuilder.success((Serializable)resultByteArray);
        }
        return DubboResultBuilder.success(null);
    }

    public void setAppPort(String appPort) {
        this.appPort = appPort;
    }

    public void setZookeeperAddress(String zookeeperAddress) {
        this.zookeeperAddress = zookeeperAddress;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public void setContextPath(String contextPath) {
        this.contextPath = contextPath;
    }

    public static void main(String[] args) throws UnknownHostException {
        InetAddress addr = InetAddress.getLocalHost();
        String ip = addr.getHostAddress();
        System.out.println(ip);
        System.out.println(InetUtils.getLocalAddress().getHostAddress());
    }

    public void destroy() throws Exception {
        if (this.serviceDiscovery != null) {
            CloseableUtils.closeQuietly(this.serviceDiscovery);
        }
        if (this.client != null) {
            CloseableUtils.closeQuietly((Closeable)this.client);
        }
    }
}

