/*
 * Decompiled with CFR 0.152.
 */
package com.beiming.pigeons.api.discover;

import com.beiming.pigeons.api.exception.KangarooException;
import com.beiming.pigeons.api.producer.ProducerService;
import com.caucho.hessian.client.HessianProxyFactory;
import com.google.common.collect.Maps;
import java.util.Map;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.retry.ExponentialBackoffRetry;
import org.apache.curator.x.discovery.ProviderStrategy;
import org.apache.curator.x.discovery.ServiceDiscovery;
import org.apache.curator.x.discovery.ServiceDiscoveryBuilder;
import org.apache.curator.x.discovery.ServiceInstance;
import org.apache.curator.x.discovery.ServiceProvider;
import org.apache.curator.x.discovery.details.InstanceSerializer;
import org.apache.curator.x.discovery.details.JsonInstanceSerializer;
import org.apache.curator.x.discovery.strategies.RandomStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KangarooDiscovery {
    private static final Logger LOGGER = LoggerFactory.getLogger(KangarooDiscovery.class);
    private static CuratorFramework client;
    private static ServiceDiscovery<Void> serviceDiscovery;
    private static ServiceProvider<Void> provider;
    private static Map<String, ProducerService> producerMap;
    private static HessianProxyFactory proxyFactory;

    public static void start(String zookeeperAddress) {
        try {
            ExponentialBackoffRetry retryPolicy = new ExponentialBackoffRetry(1000, 3);
            client = CuratorFrameworkFactory.builder().connectString(zookeeperAddress).sessionTimeoutMs(10000).connectionTimeoutMs(10000).retryPolicy((RetryPolicy)retryPolicy).namespace("pigeons").build();
            client.start();
            JsonInstanceSerializer serializer = new JsonInstanceSerializer(Void.class);
            serviceDiscovery = ServiceDiscoveryBuilder.builder(Void.class).client(client).serializer((InstanceSerializer)serializer).basePath("msgServices").build();
            serviceDiscovery.start();
            provider = serviceDiscovery.serviceProviderBuilder().serviceName("kangarooApp").providerStrategy((ProviderStrategy)new RandomStrategy()).build();
            provider.start();
        }
        catch (Throwable t) {
            throw new KangarooException("\u53d1\u73b0\u8005\u7684\u7c7b\u542f\u52a8\u5931\u8d25", t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ProducerService getProducer() {
        try {
            ServiceInstance serviceInstance = provider.getInstance();
            if (serviceInstance == null) {
                LOGGER.error("\u6ca1\u6709\u627e\u5230\u6d88\u606f\u7cfb\u7edf\u7684\u670d\u52a1\u6ce8\u518c========");
            }
            String serviceUrl = serviceInstance.getUriSpec().build();
            LOGGER.info("\u53d1\u73b0\u6d88\u606f\u7cfb\u7edf\u7684\u670d\u52a1\u5730\u5740\u4e3a:" + serviceUrl);
            ProducerService producerService = producerMap.get(serviceUrl);
            if (producerService != null) return producerService;
            Class<KangarooDiscovery> clazz = KangarooDiscovery.class;
            synchronized (KangarooDiscovery.class) {
                producerService = producerMap.get(serviceUrl);
                if (producerService != null) return producerService;
                producerService = (ProducerService)proxyFactory.create(ProducerService.class, serviceUrl);
                producerMap.put(serviceUrl, producerService);
                // ** MonitorExit[var3_4] (shouldn't be in output)
                return producerService;
            }
        }
        catch (Throwable t) {
            throw new KangarooException("\u6d88\u606f\u53d1\u9001\u8005\u5ba2\u6237\u7aef\u53d1\u9001\u5f02\u5e38", t);
        }
    }

    static {
        producerMap = Maps.newHashMap();
        proxyFactory = new HessianProxyFactory();
    }
}

