/*
 * Decompiled with CFR 0.152.
 */
package com.beiming.pigeons.api.producer.hessian;

import com.beiming.framework.domain.DubboResult;
import com.beiming.pigeons.api.producer.hessian.HessianProducerClient;
import com.beiming.pigeons.api.producer.hessian.SenderMessageDto;
import java.io.Serializable;
import org.apache.commons.lang3.StringUtils;

public class HessianRpcProducerService {
    private String topic;
    private String receiverAdapterAddress;
    private String receiverServiceName;
    private String receiverMethodName;
    private String callbackAdapterAddress;
    private String callbackServiceName;
    private String callbackMethodName;
    private HessianProducerClient producerClient;

    public DubboResult<String> sendMsg(Serializable receiverParam) {
        SenderMessageDto messageDto = new SenderMessageDto();
        if (StringUtils.isNotEmpty((CharSequence)this.getCallbackAdapterAddress())) {
            messageDto.setCallbackAddress(this.getCallbackAdapterAddress() + "$$" + this.getCallbackServiceName() + "." + this.getCallbackMethodName());
        }
        messageDto.setReceiverAddress(this.getReceiverAdapterAddress() + "$$" + this.getReceiverServiceName() + "." + this.getReceiverMethodName());
        messageDto.setDeliverType(this.getDeliverType());
        messageDto.setTopic(this.getTopic());
        messageDto.setReceiverParam(receiverParam);
        return this.getProducerClient().sendMessage(messageDto);
    }

    private boolean needCallback() {
        return StringUtils.isNotEmpty((CharSequence)this.getCallbackAdapterAddress()) && StringUtils.isNotEmpty((CharSequence)this.callbackServiceName) && StringUtils.isNotEmpty((CharSequence)this.callbackMethodName);
    }

    public String getCallbackServiceName() {
        return this.callbackServiceName;
    }

    public void setCallbackServiceName(String callbackServiceName) {
        this.callbackServiceName = callbackServiceName;
    }

    public String getCallbackMethodName() {
        return this.callbackMethodName;
    }

    public void setCallbackMethodName(String callbackMethodName) {
        this.callbackMethodName = callbackMethodName;
    }

    public String getReceiverAdapterAddress() {
        return this.receiverAdapterAddress;
    }

    public Integer getDeliverType() {
        return 2;
    }

    public String getTopic() {
        return this.topic;
    }

    public void setTopic(String topic) {
        this.topic = topic;
    }

    public String getReceiverServiceName() {
        return this.receiverServiceName;
    }

    public String getReceiverMethodName() {
        return this.receiverMethodName;
    }

    public void setReceiverMethodName(String receiverMethodName) {
        this.receiverMethodName = receiverMethodName;
    }

    public String getCallbackAdapterAddress() {
        return this.callbackAdapterAddress;
    }

    public void setCallbackAdapterAddress(String callbackAdapterAddress) {
        this.callbackAdapterAddress = callbackAdapterAddress;
    }

    public void setReceiverAdapterAddress(String receiverAdapterAddress) {
        this.receiverAdapterAddress = receiverAdapterAddress;
    }

    public HessianProducerClient getProducerClient() {
        return this.producerClient;
    }

    public void setProducerClient(HessianProducerClient producerClient) {
        this.producerClient = producerClient;
    }

    public void setReceiverServiceName(String receiverServiceName) {
        this.receiverServiceName = receiverServiceName;
    }
}

