/*
 * Decompiled with CFR 0.152.
 */
package com.beiming.pigeons.api.producer.rocketmq;

import com.beiming.framework.context.AppNameContextHolder;
import com.beiming.framework.domain.PlatformConfig;
import com.beiming.framework.util.RequestIdUtils;
import com.beiming.pigeons.api.exception.KangarooException;
import com.beiming.pigeons.api.utils.JsonSerializeUtil;
import com.google.common.base.MoreObjects;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.commons.lang3.StringUtils;
import org.apache.rocketmq.common.message.Message;

public class RocketMessageDto
implements Serializable {
    private final String topic;
    private final String key;
    private final Object data;
    private final Message message;
    private final String tags;

    public RocketMessageDto(String topic, String key, Object data) {
        this(topic, "", key, data);
    }

    public RocketMessageDto(String topic, String tags, String key, Object data) {
        if (StringUtils.isEmpty((CharSequence)topic)) {
            throw new KangarooException("\u4f20\u8f93\u7684\u6d88\u606f\u4e3b\u9898\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((CharSequence)key)) {
            throw new KangarooException("\u4f20\u8f93\u7684\u6d88\u606f\u5173\u952e\u5b57\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String keyTrim = key.trim();
        if (StringUtils.contains((CharSequence)keyTrim, (CharSequence)" ")) {
            throw new KangarooException("\u4f20\u8f93\u7684\u6d88\u606f\u5173\u952e\u5b57\u4e0d\u80fd\u5305\u542b\u7a7a\u683c");
        }
        if (data == null) {
            throw new KangarooException("\u4f20\u8f93\u7684\u6d88\u606f\u4f53\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((CharSequence)PlatformConfig.getPlatform())) {
            throw new KangarooException("\u6d88\u606f\u7684\u5e73\u53f0\u6807\u8bc6\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((CharSequence)PlatformConfig.getSystem())) {
            throw new KangarooException("\u6d88\u606f\u7684\u7cfb\u7edf\u6807\u8bc6\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String appName = AppNameContextHolder.getAppName();
        if (StringUtils.isEmpty((CharSequence)appName)) {
            throw new KangarooException("appName\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String requestId = RequestIdUtils.generateNextRequestId();
        Message message = new Message();
        try {
            Field field = data.getClass().getSuperclass().getDeclaredField("appName");
            if (field == null) {
                throw new KangarooException("\u5fc5\u987b\u7ee7\u627fBaseMessageDto");
            }
            Method m = data.getClass().getMethod("setAppName", String.class);
            m.invoke(data, appName);
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        message.setKeys(keyTrim);
        message.setTags(tags);
        message.setTopic(topic);
        message.setTags(tags);
        message.setBody(JsonSerializeUtil.serialize(data));
        message.putUserProperty("requestId", requestId);
        message.putUserProperty("PLATFORM", PlatformConfig.getPlatform());
        message.putUserProperty("SYSTEMNAME", PlatformConfig.getSystem());
        this.message = message;
        this.tags = tags;
        this.data = data;
        this.topic = topic;
        this.key = key;
    }

    public Message getMessage() {
        return this.message;
    }

    public String getTopic() {
        return this.topic;
    }

    public String getKey() {
        return this.key;
    }

    public Object getData() {
        return this.data;
    }

    public String getTags() {
        return this.tags;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("topic", (Object)this.topic).add("key", (Object)this.key).add("data", this.data).add("message", (Object)this.message).add("tags", (Object)this.tags).toString();
    }
}

