/*
 * Decompiled with CFR 0.152.
 */
package com.beiming.pigeons.api.producer.rocketmq;

import com.alibaba.fastjson.JSONObject;
import com.beiming.framework.domain.DubboResult;
import com.beiming.framework.domain.DubboResultBuilder;
import com.beiming.framework.domain.PlatformConfig;
import com.beiming.framework.enums.DubboResultCodeEnums;
import com.beiming.framework.util.RequestIdUtils;
import com.beiming.pigeons.api.producer.MessageDto;
import com.beiming.pigeons.api.producer.ProducerService;
import com.beiming.pigeons.api.producer.rocketmq.RocketMessageDto;
import com.beiming.pigeons.api.producer.rocketmq.RocketProducerTopicDto;
import com.beiming.pigeons.api.rocketmq.RocketMqAddrService;
import com.beiming.pigeons.api.rocketmq.RocketMqClientDto;
import com.beiming.pigeons.api.utils.InetUtils;
import com.beiming.pigeons.api.utils.JsonSerializeUtil;
import com.beiming.pigeons.api.utils.StopWatch;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentMap;
import org.apache.rocketmq.client.exception.MQClientException;
import org.apache.rocketmq.client.producer.DefaultMQProducer;
import org.apache.rocketmq.client.producer.SendResult;
import org.apache.rocketmq.client.producer.SendStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.util.StringUtils;

public class RocketProducerClient
implements ApplicationListener<ContextRefreshedEvent>,
DisposableBean {
    private final Logger logger = LoggerFactory.getLogger(RocketProducerClient.class);
    private String rocketMqName;
    private String mqProducerGroup;
    private ProducerService producerService;
    private RocketMqAddrService rocketMqAddrService;
    private DefaultMQProducer defaultMQProducer;
    private volatile boolean isStarted = false;
    private volatile boolean startError = false;
    private static final Set<String> TOPICS = Sets.newConcurrentHashSet();
    private static final ConcurrentMap<String, DefaultMQProducer> PRODUCERS = Maps.newConcurrentMap();
    String localIp = InetUtils.getLocalHostIp();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() throws MQClientException, InterruptedException {
        RocketMqClientDto clientDto = new RocketMqClientDto();
        clientDto.setClientIp(this.localIp);
        clientDto.setClientGroup(this.mqProducerGroup);
        clientDto.setRocketMqName(this.rocketMqName);
        clientDto.setClientType("PRODUCER");
        DubboResult<String> addrResult = this.rocketMqAddrService.getRmNamesrvAddr(clientDto);
        if (!addrResult.isSuccess()) {
            this.logger.error("\u83b7\u53d6 rocketMq\uff1a" + this.rocketMqName + " nameServer \u5730\u5740\u5931\u8d25\uff0cmessage=" + addrResult.getMessage());
            return;
        }
        String namesrvAddr = (String)((Object)addrResult.getData());
        if (StringUtils.isEmpty((Object)this.mqProducerGroup) || StringUtils.isEmpty((Object)namesrvAddr)) {
            this.logger.error("mqProducerGroup or namesrvAddr parameters is null");
            return;
        }
        this.logger.info("DefaultMQProducer " + this.mqProducerGroup + " initialize!");
        this.logger.info("mqProducerGroup:" + this.mqProducerGroup);
        this.logger.info("namesrvAddr:" + namesrvAddr);
        if (PRODUCERS.containsKey(this.mqProducerGroup)) {
            this.defaultMQProducer = (DefaultMQProducer)PRODUCERS.get(this.mqProducerGroup);
            this.logger.info(this.mqProducerGroup + " \u7684Producer\u5df2\u7ecf\u88ab\u521b\u5efa\uff0c\u76f4\u63a5\u8fd4\u56de\uff0c\u5efa\u8bae\u68c0\u67e5\u914d\u7f6e\u662f\u5426\u91cd\u590d");
            return;
        }
        this.defaultMQProducer = new DefaultMQProducer(this.mqProducerGroup);
        if (PRODUCERS.putIfAbsent(this.mqProducerGroup, this.defaultMQProducer) != null) {
            this.defaultMQProducer = (DefaultMQProducer)PRODUCERS.get(this.mqProducerGroup);
            this.logger.info(this.mqProducerGroup + " \u7684Producer\u5df2\u7ecf\u88ab\u521b\u5efa\uff0c\u76f4\u63a5\u8fd4\u56de\uff0c\u5efa\u8bae\u68c0\u67e5\u914d\u7f6e\u662f\u5426\u91cd\u590d");
            return;
        }
        this.defaultMQProducer.setUnitName(this.rocketMqName + "_" + this.mqProducerGroup);
        this.defaultMQProducer.setNamesrvAddr(namesrvAddr);
        this.defaultMQProducer.setVipChannelEnabled(false);
        this.defaultMQProducer.start();
        Thread.sleep(500L);
        this.isStarted = true;
        RocketProducerClient rocketProducerClient = this;
        synchronized (rocketProducerClient) {
            this.notifyAll();
        }
        this.logger.info("DefaultMQProducer start success!");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DubboResult sendMessage(RocketMessageDto msgDto) {
        DubboResult result = this.validateProducerClientStatus();
        if (!result.isSuccess()) {
            return result;
        }
        if (msgDto == null) {
            this.logger.error("msgDto\u4e0d\u80fd\u4e3anull\u3002");
            return DubboResultBuilder.error((int)DubboResultCodeEnums.PARAM_ERROR.value(), (String)"msgDto\u4e0d\u80fd\u4e3anull\u3002");
        }
        this.saveTopic(msgDto.getTopic());
        StopWatch stopWatch = new StopWatch();
        try {
            this.logger.info("\u5f00\u59cb\u53d1\u9001\u6d88\u606f\uff0c\u6d88\u606f\u4e3a\uff1a{}, \u4e1a\u52a1key\u4e3a:{} topic\u4e3a:{}, tags\u4e3a:{}", new Object[]{JSONObject.toJSONString((Object)msgDto.getData()), msgDto.getKey(), msgDto.getTopic(), msgDto.getTags()});
            SendResult sendResult = this.defaultMQProducer.send(msgDto.getMessage());
            if (sendResult != null && sendResult.getSendStatus() != SendStatus.SEND_OK) {
                this.logger.error("\u53d1\u9001\u6d88\u606f\u72b6\u6001\u6709\u9519:" + JSONObject.toJSONString((Object)sendResult));
                DubboResult dubboResult = DubboResultBuilder.success((Serializable)sendResult.getSendStatus());
                return dubboResult;
            }
            DubboResult dubboResult = DubboResultBuilder.success(null);
            return dubboResult;
        }
        catch (Exception e) {
            this.logger.error("\u901a\u8fc7Rocket\u53d1\u9001\u6d88\u606f\u5931\u8d25,\u5c06\u6d88\u606f\u4fdd\u5b58\u81f3\u6d88\u606f\u4e2d\u5fc3\u3002", (Throwable)e);
            DubboResult dubboResult = this.saveToMessageCenter(msgDto);
            return dubboResult;
        }
        finally {
            this.logger.info("rocketmq mq \u53d1\u9001\u6d88\u606f\u7ed3\u675f\uff0c \u65f6\u95f4\u4e3a\uff1a{}ms", (Object)stopWatch.elapsedTime());
        }
    }

    private DubboResult saveToMessageCenter(RocketMessageDto msgDto) {
        MessageDto messageDto = new MessageDto();
        String requestId = RequestIdUtils.generateNextRequestId();
        messageDto.setReceiverParam(JsonSerializeUtil.serialize(msgDto.getData()));
        messageDto.setReceiverAddress(this.rocketMqName);
        messageDto.setSourcePlatform(PlatformConfig.getPlatform());
        messageDto.setDeliverType(3);
        messageDto.setKeyword(msgDto.getKey());
        messageDto.setTopic(msgDto.getTopic());
        messageDto.setTags(msgDto.getTags());
        messageDto.setRequestId(requestId);
        messageDto.setClientIp(this.localIp);
        return this.producerService.sendMessage(messageDto);
    }

    private void saveTopic(final String topic) {
        if (!TOPICS.contains(topic) && TOPICS.add(topic)) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    RocketProducerTopicDto topicDto = new RocketProducerTopicDto();
                    topicDto.setProducerGroup(RocketProducerClient.this.mqProducerGroup);
                    topicDto.setRocketMqName(RocketProducerClient.this.rocketMqName);
                    topicDto.setTopic(topic);
                    RocketProducerClient.this.producerService.saveTopic(topicDto);
                }
            }).start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DubboResult validateProducerClientStatus() {
        if (!this.isStarted) {
            try {
                RocketProducerClient rocketProducerClient = this;
                synchronized (rocketProducerClient) {
                    for (int count = 20; !this.isStarted && count > 0; --count) {
                        if (this.startError) {
                            return DubboResultBuilder.error((int)DubboResultCodeEnums.INTERNAL_ERROR.value(), (String)"rocketMqProducer\u542f\u52a8\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u65e5\u5fd7");
                        }
                        this.wait(2000L);
                    }
                }
            }
            catch (InterruptedException e) {
                this.logger.error("\u53d1\u9001\u6d88\u606f\u7b49\u5f85\u521d\u59cb\u5316\u9519\u8bef", (Throwable)e);
                throw new RuntimeException(e);
            }
        }
        if (this.startError) {
            this.logger.error("rocketMqProducer\u542f\u52a8\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u542f\u52a8\u65e5\u5fd7\u662f\u5426\u6709\u5f02\u5e38\u3002");
            return DubboResultBuilder.error((int)DubboResultCodeEnums.INTERNAL_ERROR.value(), (String)"rocketMqProducer\u542f\u52a8\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u65e5\u5fd7");
        }
        return DubboResultBuilder.success();
    }

    public void destroy() {
        try {
            if (this.defaultMQProducer != null) {
                this.defaultMQProducer.shutdown();
            }
        }
        catch (Throwable t) {
            this.logger.error("RocketMq \u5173\u95ed\u5f02\u5e38", t);
        }
    }

    public void setMqProducerGroup(String mqProducerGroup) {
        this.mqProducerGroup = mqProducerGroup;
    }

    public void setRocketMqName(String rocketMqName) {
        this.rocketMqName = rocketMqName;
    }

    public void setProducerService(ProducerService producerService) {
        this.producerService = producerService;
    }

    public void setRocketMqAddrService(RocketMqAddrService rocketMqAddrService) {
        this.rocketMqAddrService = rocketMqAddrService;
    }

    public void onApplicationEvent(ContextRefreshedEvent contextRefreshedEvent) {
        Timer timer = new Timer();
        timer.schedule(new TimerTask(){

            @Override
            public void run() {
                block3: {
                    try {
                        RocketProducerClient.this.init();
                    }
                    catch (Exception e) {
                        RocketProducerClient.this.logger.error("defaultMqProducer\u542f\u52a8\u5931\u8d25", (Throwable)e);
                        RocketProducerClient.this.startError = true;
                        for (int i = 0; i < 5 && !RocketProducerClient.this.isStarted; ++i) {
                            this.reInit(i);
                        }
                        if (!RocketProducerClient.this.startError) break block3;
                        RocketProducerClient.this.logger.error("5\u6b21\u91cd\u65b0\u542f\u52a8producerClient:" + RocketProducerClient.this.mqProducerGroup + "\u4ecd\u7136\u5931\u8d25");
                    }
                }
            }

            private void reInit(int i) {
                try {
                    Thread.sleep(3000L);
                    RocketProducerClient.this.init();
                    RocketProducerClient.this.startError = false;
                    RocketProducerClient.this.logger.info("\u91cd\u65b0\u542f\u52a8producerClient" + RocketProducerClient.this.mqProducerGroup + ", \u91cd\u65b0\u542f\u52a8\u6210\u529f");
                }
                catch (Exception e1) {
                    RocketProducerClient.this.logger.error(RocketProducerClient.this.mqProducerGroup + "\u7b2c" + (i + 1) + "\u6b21\u91cd\u65b0\u542f\u52a8\u5931\u8d25", (Throwable)e1);
                }
            }
        }, 2000L);
    }
}

