package com.beiming.xizang.room.api.dto;

import java.io.Serializable;
import java.util.UUID;
import com.beiming.framework.message.BaseMessageDto;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * 案件流转
 * 
 * @author huaisf
 *
 */
@Data
@NoArgsConstructor
public class CaseCirculationMessageDTO extends BaseMessageDto implements Serializable {

  private static final long serialVersionUID = 1L;

  private String key;

  private String senderId;

  private String senderName;

  private String content;

  private Long roomId;
  
  private String categoryBig;
  
  public CaseCirculationMessageDTO(String senderId, String senderName, String content, Long roomId,
      String categoryBig) {
    this.content = content;
    this.senderId = senderId;
    this.senderName = senderName;
    this.key = UUID.randomUUID().toString();
    this.roomId = roomId;
    this.categoryBig = categoryBig;
  }
  
  
}
