package com.beiming.xizang.room.api.dto.request;

import java.io.Serializable;
import javax.validation.constraints.NotBlank;
import com.beiming.xizang.room.api.constants.ChatApiValidationMessage;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * 删除视频人员
 * 
 * @author qsh
 *
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class DeleteMemberReqDTO implements Serializable {
  private static final long serialVersionUID = 1L;

  @NotBlank(message = ChatApiValidationMessage.ROOM_ID_NOT_BLANK)
  private String roomId;
  @NotBlank(message = ChatApiValidationMessage.MEMBER_ID_NOT_BLANK)
  private String memberId;

}
