package com.beiming.xizang.room.api.dto.request;

import java.io.Serializable;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import com.beiming.xizang.room.api.constants.ChatApiValidationMessage;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * 获取单条消息dto
 * 
 * @author lb
 *
 */
@Data
@NoArgsConstructor
public class LoadMessageReqDTO implements Serializable {
  private static final long serialVersionUID = -332961286998432726L;

  /**
   * 消息id
   */
  @NotNull(message = ChatApiValidationMessage.MESSAGE_ID_NOT_NULL)
  private Long messageId;

  /**
   * 成员id
   */
  @NotBlank(message = ChatApiValidationMessage.MEMBER_ID_NOT_BLANK)
  private String memberId;

  public LoadMessageReqDTO(Long messageId, String memberId) {
    super();
    this.messageId = messageId;
    this.memberId = memberId;
  }
}
