package com.beiming.xizang.room.api.dto.request;

import java.io.Serializable;
import java.util.List;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

@SuppressWarnings("serial")
@Data
@AllArgsConstructor
@NoArgsConstructor
public class RoomInviteReqDTO implements Serializable {

  @NotBlank
  private String inviteType;

  @NotBlank
  private String inviteMode;

  @NotBlank
  private String roomRole;

  @NotBlank
  private String title;


  private List<RoomInviteBaseReqDTO> bases;

  @NotNull
  private Long roomId;

  private Long lawCaseId;

  private Long meetingId;
  
  @NotBlank
  private String meetingType;

  @NotNull
  private Long orderStartTime;

}
