package com.beiming.xizang.room.api.dto.request;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.Size;
import com.beiming.xizang.room.api.constants.ChatApiConstant;
import com.beiming.xizang.room.api.constants.ChatApiValidationMessage;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;

@Data
@EqualsAndHashCode(callSuper = false)
@NoArgsConstructor
public class SendFileMessageReqDTO extends SendMessageReqDTO {


  private static final long serialVersionUID = -1271793729230614248L;

  @NotBlank(message = ChatApiValidationMessage.FILE_ID_NOT_BLANK)
  @Size(max = ChatApiConstant.FILE_ID_MAX_SIZE, message = ChatApiValidationMessage.FILE_ID_TOO_LONG)
  private String fileId;

  @NotBlank(message = ChatApiValidationMessage.FILE_NAME_NOT_BLANK)
  @Size(max = ChatApiConstant.FILE_NAME_MAX_SIZE,
      message = ChatApiValidationMessage.FILE_NAME_TOO_LONG)
  private String fileName;

  private String filePath;

  /**
   * 音视频文件时长
   */
  private String mediaLength;

  private String subjectType;

  private Long subjectId;
  /**
   * 文件类型
   *
   * @see com.beiming.odr.basic.api.enums.CategoryBigEnums
   */
  private String categoryBig;

  public SendFileMessageReqDTO(String roomId, String senderId, String fileId, String fileName) {
    super(roomId, senderId);
    this.fileId = fileId;
    this.fileName = fileName;
  }

  public SendFileMessageReqDTO(String roomId, String senderId, String receiverId, String fileId,
      String fileName) {
    super(roomId, senderId, receiverId);
    this.fileId = fileId;
    this.fileName = fileName;
  }

  public SendFileMessageReqDTO(String roomId, String senderId, String receiverId, String fileId,
      String fileName, String subjectType, Long subjectId) {
    super(roomId, senderId, receiverId);
    this.fileId = fileId;
    this.fileName = fileName;
    this.subjectType = subjectType;
    this.subjectId = subjectId;
  }
}
