package com.beiming.xizang.room.api.dto.request;

import java.io.Serializable;
import javax.validation.constraints.NotBlank;
import com.beiming.xizang.room.api.constants.ChatApiValidationMessage;
import lombok.Data;
import lombok.NoArgsConstructor;

@Data
@NoArgsConstructor
public class SendMessageReqDTO implements Serializable {

  private static final long serialVersionUID = -1271793729230614248L;

  /**
   * 房间主键id
   */
  @NotBlank(message = ChatApiValidationMessage.ROOM_ID_NOT_BLANK)
  protected String roomId;
  /**
   * 发送人id
   */
  @NotBlank(message = ChatApiValidationMessage.SENDER_ID_NOT_BLANK)
  protected String senderId;
  /**
   * 接收人id
   */
  protected String receiverId;

  public SendMessageReqDTO(String roomId, String senderId) {
    this.roomId = roomId;
    this.senderId = senderId;
  }

  public SendMessageReqDTO(String roomId, String senderId, String receiverId) {
    this(roomId, senderId);
    this.receiverId = receiverId;
  }
}
