package com.beiming.xizang.room.api.dto.request;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.Size;
import com.beiming.xizang.room.api.constants.ChatApiConstant;
import com.beiming.xizang.room.api.constants.ChatApiValidationMessage;
import com.beiming.xizang.room.api.enums.ChatMessageTypeEnums;
import com.beiming.xizang.room.api.enums.MessageResourceEnums;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;

@Data
@EqualsAndHashCode(callSuper = false)
@NoArgsConstructor
public class SendTextMessageReqDTO extends SendMessageReqDTO {

  private static final long serialVersionUID = -1298142885154912794L;

  /**
   * 消息内容
   */
  @NotBlank(message = ChatApiValidationMessage.SEND_CONTENT_NOT_BLANK)
  @Size(max = ChatApiConstant.MESSAGE_CONTENT_MAX_SIZE,
      message = ChatApiValidationMessage.SEND_CONTENT_TOO_LONG)
  private String messageContent;

  //  @NotEmpty(message = ChatApiValidationMessage.SEND_MESSAGE_RESOURCE_NOT_BLANK)
  private MessageResourceEnums messageResource;
  /**
   * messageType细分类
   */
  private String categoryBig;
  /**
   * 消息接收人名称
   */
  private String receiverNames;
  
  private ChatMessageTypeEnums messageType;
  
  private String subjectType;
  
  private Long subjectId;
  
  public SendTextMessageReqDTO(String roomId, String senderId, String messageContent,
      MessageResourceEnums... messageResourceEnums) {
    super(roomId, senderId);
    this.messageContent = messageContent;
    if (messageResourceEnums != null && messageResourceEnums.length > 0) {
      MessageResourceEnums enums = messageResourceEnums[0];
      this.messageResource = enums == null ? MessageResourceEnums.INVITATION_VIDEO : enums;
    }
  }

  public SendTextMessageReqDTO(String roomId, String senderId, String receiverId,
      String messageContent, MessageResourceEnums... messageResourceEnums) {
    super(roomId, senderId, receiverId);
    this.messageContent = messageContent;
    if (messageResourceEnums != null && messageResourceEnums.length > 0) {
      MessageResourceEnums enums = messageResourceEnums[0];
      this.messageResource = enums == null ? MessageResourceEnums.HANDLER_INPUT : enums;
    }
  }
  
  public SendTextMessageReqDTO(String roomId, String senderId, String receiverId,
      String messageContent, String subjectType, Long subjectId,
      MessageResourceEnums... messageResourceEnums) {
    super(roomId, senderId, receiverId);
    this.subjectType = subjectType;
    this.subjectId = subjectId;
    this.messageContent = messageContent;
    if (messageResourceEnums != null && messageResourceEnums.length > 0) {
      MessageResourceEnums enums = messageResourceEnums[0];
      this.messageResource = enums == null ? MessageResourceEnums.HANDLER_INPUT : enums;
    }
  }
  
  
  public SendTextMessageReqDTO(String roomId, String senderId, 
      String messageContent, MessageResourceEnums messageResourceEnums, String categoryBig) {
    super(roomId, senderId);
    this.messageContent = messageContent;
    this.messageResource = messageResourceEnums;
    this.categoryBig = categoryBig;
  }
}
