package com.beiming.xizang.room.api.dto.request;

import java.io.Serializable;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import com.beiming.xizang.room.api.constants.ValidationMessage;
import com.beiming.xizang.room.api.enums.CTypeEnums;
import lombok.Data;

@Data
public class VersionCheckReqDTO implements Serializable {
  /**
   * 
   */
  private static final long serialVersionUID = -147336797768755420L;
  /**
   * 系统标识
   */
  @NotNull(message = ValidationMessage.SYS_IS_EMPTY)
  private CTypeEnums cType;
  /**
   * app版本号
   */
  @NotBlank(message = ValidationMessage.APPVERSION_NOT_BLANK)
  private String appVersion;
  /**
   * app名称
   */
  @NotBlank(message = ValidationMessage.APPNAME_NOT_BLANK)
  private String appName;
}
