package com.beiming.xizang.room.api.dto.response;

import java.io.Serializable;
import com.beiming.xizang.room.api.enums.MemberStatusEnums;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * 房间成员实体类
 * 
 * @author lb
 *
 */
@Data
@NoArgsConstructor
public class ArbitrationRoomMemberDTO implements Serializable {

  private static final long serialVersionUID = -2274691124620422737L;

  /**
   * 房间主键id
   */
  private String roomId;

  /**
   * 成员id
   */
  private String memberId;
  /**
   * 成员名称
   */
  private String memberName;
  /**
   * 成员类型
   */
  private String memberType;
  /**
   * 成员状态
   */
  private MemberStatusEnums memberStatus;
  /**
   * 是否为管理员
   */
  private boolean master;

  /**
   * 成员角色title
   */
  private String title;

  /**
   * 最后一条聊天记录
   */
  private MessageResDTO lastMessage;

  /**
   * 总人数
   */
  private Integer memberCount;

  /**
   * 未读消息数量
   */
  private Integer unreadMeeageCount;

  public ArbitrationRoomMemberDTO(MemberResDTO memberResDTO, MessageResDTO messageResDTO,
      Integer unreadMeeageCount) {
    this.roomId = memberResDTO.getRoomId();
    this.memberId = memberResDTO.getMemberId();
    this.memberName = memberResDTO.getMemberName();
    this.memberType = memberResDTO.getMemberType();
    this.memberStatus = memberResDTO.getMemberStatus();
    this.master = memberResDTO.isMaster();
    this.title = memberResDTO.genTitle();
    this.lastMessage = messageResDTO;
    this.unreadMeeageCount = unreadMeeageCount == null ? 0 : unreadMeeageCount;
  }
}
