package com.beiming.xizang.room.api.dto.response;

import java.io.Serializable;
import java.util.Date;
import com.beiming.xizang.room.api.enums.ChatMessageTypeEnums;
import com.beiming.xizang.room.api.enums.FileStatusEnums;
import com.beiming.xizang.room.api.enums.MessageResourceEnums;
import lombok.Data;

@Data
public class ChatInfoResDTO implements Serializable {
  
  /**
   * 
   */
  private static final long serialVersionUID = -706132245427920670L;
  /**
   * 主键
   */
  private Long id;
  /**
   * 房间id
   */
  private Long roomId;
  /**
   * 消息发送人
   */
  private String senderId;
  /**
   * 消息接收人
   */
  private String receiverId;
  /**
   * 发送人名称
   */
  private String senderName;
  /**
   * 接收人名称
   */
  private String receiverName;
  /**
   * 消息类型(文本、文件等)
   */
  private ChatMessageTypeEnums messageType;

  /**
   * 消息来源 （手动输入、语音识别）
   */
  private MessageResourceEnums messageResource;
  /**
   * 消息内容
   */
  private String messageContent;
  /**
   * 文件ID
   */
  private String fileId;
  /**
   * 文件大分类
   */
  private String categoryBig;
  /**
   * 业务类型
   */
  private String subjectType;
  /**
   * 业务id
   */
  private Long subjectId;

  /**
   * 状态 0 正常 1 删除
   */
  private String status;
  /**
   * 备注
   */
  private String remark;
  /**
   * 创建人
   */
  private String createUser;
  /**
   * 创建时间
   */
  private Date createTime;
  /**
   * 修改人
   */
  private String updateUser;
  /**
   * 修改时间
   */
  private Date updateTime;
  /**
   * 版本号
   */
  private Integer version;

  /**
   * 文件是否上传至证据
   */
  private FileStatusEnums fileStatus;

}
