package com.beiming.xizang.room.api.feign;

import java.util.List;
import javax.validation.Valid;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import com.beiming.framework.config.FeignConfig;
import com.beiming.xizang.room.api.dto.request.QuestionsDTO;
import com.beiming.xizang.room.api.dto.request.QuestionsReqDTO;

@Valid
@FeignClient(name = "xizang-room", path = "xizang-room", configuration = FeignConfig.class, contextId = "QuestionsApi")
public interface QuestionsApi {

  /**
   * 插入更新问题
   * 
   * @param questionsDTO
   * @return
   */
  @RequestMapping(value = "insertUpdateList", method = RequestMethod.POST)
  public List<QuestionsDTO> insertUpdateList(@RequestBody @Valid QuestionsReqDTO questionsReqDTO);


  /**
   * 查询全部问题
   * 
   * @return
   */
  @RequestMapping(value = "queryAll", method = RequestMethod.POST)
  public List<QuestionsDTO> queryAll(@RequestBody @Valid QuestionsReqDTO questionsReqDTO);

}
