package com.beiming.xizang.room.api.dto.request;

import java.io.Serializable;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import com.beiming.xizang.room.api.constants.ChatApiValidationMessage;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * 房间dto
 * 
 * @author lb
 *
 */
@Data
@NoArgsConstructor
public class AppendMemberDTO implements Serializable {
  private static final long serialVersionUID = 2221757280021345009L;
  /**
   * 房间主键id
   */
  @NotBlank(message = ChatApiValidationMessage.ROOM_ID_NOT_BLANK)
  private String roomId;
  /**
   * 追加人员
   */
  @NotBlank(message = ChatApiValidationMessage.APPENDER_ID_NOT_BLANK)
  private String appenderId;
  /**
   * 房间成员
   */
  @NotEmpty(message = ChatApiValidationMessage.MEMBERS_NOT_EMPTY)
  @Valid
  private List<MemberReqDTO> members;

  public AppendMemberDTO(String roomId, String appenderId, List<MemberReqDTO> members) {
    super();
    this.roomId = roomId;
    this.appenderId = appenderId;
    this.members = members;
  }
}
