package com.beiming.xizang.room.api.dto.request;

import java.io.Serializable;
import javax.validation.constraints.NotBlank;
import com.beiming.xizang.room.api.constants.ChatApiValidationMessage;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;

/**
 * 统计房间信息
 * 
 * @author djq
 *
 */
@Data
@EqualsAndHashCode(callSuper = false)
@NoArgsConstructor
public class CountRoomReqDTO implements Serializable {

  private static final long serialVersionUID = -733477589419493678L;

  /**
   * 成员id
   */
  @NotBlank(message = ChatApiValidationMessage.MEMBER_ID_NOT_BLANK)
  private String memberId;

  /**
   * 成员类型<br>
   * 
   * 管理员 MASTER<br>
   * 普通参与人 NORMAL
   * 
   * @see MemberRoleTypeEnums
   */
  // @NotBlank(message = ChatApiValidationMessage.MEMBER_TYPE_NOT_BLANK)
  // private String memberRoleType;

  /**
   * 房间类型<br>
   * 业务层面上的房间类型<br>
   * 对应subject_type
   */
  private String businessRoomType;

  public CountRoomReqDTO(String memberId) {
    this.memberId = memberId;
  }

  public CountRoomReqDTO(String memberId, String businessRoomType) {
    this.memberId = memberId;
    this.businessRoomType = businessRoomType;
  }

  public ListRoomReqDTO convertListRoomReqDTO() {
    ListRoomReqDTO dto = new ListRoomReqDTO();
    dto.setMemberId(memberId);
    dto.setBusinessRoomType(businessRoomType);
    return dto;
  }

}
