package com.beiming.xizang.room.api.dto.request;

import java.io.Serializable;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import com.beiming.xizang.room.api.constants.ChatApiConstant;
import com.beiming.xizang.room.api.constants.ChatApiValidationMessage;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * 新建房间dto
 * 
 * @author lb
 *
 */
@Data
@NoArgsConstructor
public class QueryExistRoomReqDTO implements Serializable {

  private static final long serialVersionUID = -4429081618094911317L;
  /**
   * 业务类型
   */
  @NotBlank(message = ChatApiValidationMessage.SUBJECT_TYPE_NOT_BLANK)
  @Size(max = ChatApiConstant.SUBJECT_TYPE_MAX_SIZE,
      message = ChatApiValidationMessage.SUBJECT_TYPE_TOO_LONG)
  protected String subjectType;
  /**
   * 业务id
   */
  @NotBlank(message = ChatApiValidationMessage.SUBJECT_ID_NOT_BLANK)
  @Size(max = ChatApiConstant.SUBJECT_ID_MAX_SIZE,
      message = ChatApiValidationMessage.SUBJECT_ID_TOO_LONG)
  protected String subjectId;

  /**
   * 房间成员
   */
  @NotNull(message = ChatApiValidationMessage.MEMBERS_NOT_EMPTY)
  protected Long userId;

  /**
   * 房间成员
   */
  @NotNull(message = ChatApiValidationMessage.MEMBERS_NOT_EMPTY)
  //仲裁中/法官
  protected Long meditorId;



  /**
   * 新建聊天室构造函数
   *
   * @param subjectType 业务类型，不允许为空
   * @param subjectId 业务id，不允许为空
   * @param meditorId 参与人不允许为空
   * @param userId 房间属性，允许为空
   */
  public QueryExistRoomReqDTO(String subjectType, String subjectId, Long meditorId, Long userId) {
    super();
    this.subjectType = subjectType;
    this.subjectId = subjectId;
    this.meditorId = meditorId;
    this.userId = userId;
  }

  
}
