package com.beiming.xizang.room.api.dto.request;

import java.io.Serializable;
import java.util.List;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import com.beiming.xizang.room.api.constants.QuestionsApiValidationMessage;
import com.beiming.xizang.room.api.enums.QuestionsObjectTypeEnum;
import lombok.Data;
import lombok.NoArgsConstructor;

@SuppressWarnings("serial")
@Data
@NoArgsConstructor
public class QuestionsReqDTO implements Serializable {

  @NotNull(message = QuestionsApiValidationMessage.USER_CONTENT_NOT_BLANK)
  private Long userId;

  @NotBlank(message = QuestionsApiValidationMessage.OBJECT_TYPE_CONTENT_NOT_BLANK)
  private String objectType = QuestionsObjectTypeEnum.ROLE.name();

  @NotNull(message = QuestionsApiValidationMessage.OBJECT_ID_CONTENT_NOT_BLANK)
  private Long objectId;

  private List<QuestionsDTO> questionsDTOs;
}
