package com.beiming.xizang.room.api.dto.request;

import java.io.Serializable;
import javax.validation.constraints.NotBlank;
import com.beiming.xizang.room.api.constants.ChatApiValidationMessage;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * 保存每个成员视频dto
 * 
 * @author lb
 *
 */
@Data
@NoArgsConstructor
public class SaveMemberVideoInfoReqDTO implements Serializable {

  private static final long serialVersionUID = 6256021536003753158L;
  /**
   * 流id
   */
  @NotBlank(message = ChatApiValidationMessage.STREAM_ID_NOT_BLANK)
  private String streamId;
  /**
   * 播放地址
   */
  @NotBlank(message = ChatApiValidationMessage.PLAY_URL_NOT_BLANK)
  private String playUrl;
  /**
   * 回调信息
   */
  @NotBlank(message = ChatApiValidationMessage.CALLBACK_INFO_NOT_BLANK)
  private String callbackinfo;

  public SaveMemberVideoInfoReqDTO(String streamId, String playUrl, String callbackinfo) {
    super();
    this.streamId = streamId;
    this.playUrl = playUrl;
    this.callbackinfo = callbackinfo;
  }
}
