package com.beiming.xizang.room.api.dto.request;

import java.io.Serializable;
import java.util.Date;
import com.beiming.framework.message.BaseMessageDto;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;

/**
 * Created by zli on 2020/5/11
 */
@EqualsAndHashCode(callSuper = true)
@NoArgsConstructor
@Data
public class StartMeetingMsgReqDTO extends BaseMessageDto implements Serializable {

  private static final long serialVersionUID = 8320634359728851665L;


  private String roomId;

  private Date createTime;

  public StartMeetingMsgReqDTO(String roomId) {
    this.roomId = roomId;
    this.createTime = new Date();
  }

  public StartMeetingMsgReqDTO(String roomId, Date createTime) {
    this.roomId = roomId;
    this.createTime = createTime;
  }
}
