package com.beiming.xizang.room.api.dto.request;

import java.io.Serializable;
import javax.validation.constraints.NotBlank;
import com.beiming.framework.message.BaseMessageDto;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

/**
 * package: com.beiming.odr.basic.service.consumer.dto describe: 流信息对象 create_user: xiet
 * create_date: 2018/12/14 create_time: 5:34 PM
 **/
@Setter
@Getter
@NoArgsConstructor
public class StreamInfo extends BaseMessageDto implements Serializable {

  @NotBlank(message = "流ID不允许为空")
  private String streamId;
  private String createUser;
  private String callBackUrl;
  @NotBlank(message = "参数不允许为空")
  private String params;

  public StreamInfo(String streamId, String createUser, String callBackUrl, String params) {
    this.streamId = streamId;
    this.createUser = createUser;
    this.callBackUrl = callBackUrl;
    this.params = params;
  }

  /**
   * API层调用可能无法提供创建者和回调地址， 统一由chat维护
   */
  public StreamInfo(String streamId, String params) {
    this.streamId = streamId;
    this.params = params;
  }

  @Override
  public String toString() {
    return "StreamInfo{" + "streamId='" + streamId + '\''
        + ", createUser='" + createUser + '\''
        + ", callBackUrl='" + callBackUrl + '\''
        + ", params='" + params + '\''
        + "} " + super.toString();
  }
}
