package com.beiming.xizang.room.api.enums;

import com.beiming.framework.redis.key.RedisKey;

public enum RoomRedisKeyEnum implements RedisKey {
  /**
   * 观摩
   */
  WATCH_INVITE(String.class),
  /**
   * 临时协助
   */
  TEMP_INVITE(String.class);

  private final Class<?> clazz;

  <T> RoomRedisKeyEnum(Class<T> clazz) {
    this.clazz = clazz;
  }

  @Override
  public <T> Class<T> getClazz() {
    return (Class<T>) clazz;
  }

  @Override
  public String getKey() {
    return this.name();
  }

}
